/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:18:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to list current molecules, and to add/delete them.
 *
 ***************************************************************************/
#ifndef MOLFORMSOBJ_H
#define MOLFORMSOBJ_H

#include "FormsObj.h"


class MolFormsObj : public FormsObj {

private:
  // set the state of the molecule browser
  void reset_mol_browser(void);
  
protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  MolFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: MolFormsObj.h,v $
 * Revision 1.3  1995/05/11  23:18:05  billh
 * Moved log messages to end of file.
 *
 * Revision 1.2  95/03/24  18:50:32  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/09/29  20:58:55  billh
 * Initial revision
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
