/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolAction.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 23:18:02 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MolAction object is something which performs an 'act' for a Molecule
 * object.  For example, it may change the bond radius or display all
 * alpha carbons.  It is used by the MoleculeList object to perform an
 * action on a list of objects.
 *
 ***************************************************************************/

#include "MolAction.h"
#include "Molecule.h"

/////////////////////////////  base class  ///////////////////////////
// destructor
MolAction::~MolAction(void) {
  // does nothing
}

/////////////////////////////  derived classes  /////////////////////

void MolPause::act(Molecule *m) { m->anim_dir(Animation::PAUSE); }

void MolReverse::act(Molecule *m) { m->anim_dir(Animation::REVERSE); }

void MolReverse1::act(Molecule *m) { m->anim_dir(Animation::REVERSE1); }

void MolForward::act(Molecule *m) { m->anim_dir(Animation::FORWARD); }

void MolForward1::act(Molecule *m) { m->anim_dir(Animation::FORWARD1); }

void MolSetFrame::act(Molecule *m) {
  if(val == SET_FRAME_START)
    m->goto_frame(0);
  else if(val == SET_FRAME_END)
    m->goto_frame(m->num() - 1);
  else
    m->goto_frame(val);
}

void MolSetSkip::act(Molecule *m) { m->skip(val); }

void MolAnimStyle::act(Molecule *m) { m->anim_style(newstyle); }

void MolSetSpeed::act(Molecule *m) { m->speed(speed); }

/* REVISION HISTORY:********************************************************
 *
 * $Log: MolAction.C,v $
 * Revision 1.2  1995/05/11  23:18:02  billh
 * Moved log messages to end of file.
 *
 * Revision 1.1  95/03/24  18:50:28  billh
 * Initial revision
 * 
 ***************************************************************************/
