/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GrabTool.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 22:51:40 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   This type of Tool can be used to pick up and manipulate molecules.
 * Just press button 0 to pick it up, and again to put it down
 *
 * Simple grabbing tool, derived from Tool
 * Draw a representation as a cylinder with silver cylindrival tip
 * (supposed to be like a bar magnet)
 * Use button 0 to grab onto the active molecules
 * press again to release it
 ***************************************************************************/
#ifndef GRABTOOL_H
#define GRABTOOL_H

#include "Tool.h"

class GrabTool : public Tool {

private:
  // draw a cylinder with the given number of sides.
  // because of the graphics transformations already
  // done, I can assume the base is at (0,0,0) and the
  // tip is at (1,0,0).
  void draw_cylindrical_pointer(ToolInfo *info, int numsides);
  int grabbed;
  float x, y, z;
 
public:
  GrabTool(char *name, Scene *sc, int drawlist_size = 2) 
     : Tool(name, sc, drawlist_size) {
    tip_checking = FULL;
    grabbed = FALSE;
  }
  virtual void tool_event(ToolControl *toolctrl, ToolInfo *info);
  virtual void redraw_list(ToolInfo *info);
  virtual void button_event(ToolControl *toolctrl, ToolInfo *info);
  
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: GrabTool.h,v $
 * Revision 1.3  1995/05/11  22:51:40  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.2  95/03/24  18:50:07  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/11/03  12:24:17  dalke
 * Initial revision
 *
 ***************************************************************************/
