/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Global.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.19 $	$Date: 1995/05/13 01:36:00 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Global data structures, configuration settings, and macros for the 
 * vmd library.
 *
 ***************************************************************************/
#ifndef GLOBAL_DEFS_H
#define GLOBAL_DEFS_H

// standard includes for all modules
#include "utilities.h"
#include "config.h"
#include "Inform.h"

// the name of this program, and temp directory to use
extern char *myName;
extern char *myPath;
extern char *myTempDir;
extern char *dataPath;

// location of the Babel executable (or NULL)
extern char *vmdBabelBin;

// name of the HTML viewer to use (or NULL if none)
extern char *vmdHTMLViewer;

// display device in which the images are rendered
class DisplayDevice;
extern DisplayDevice *display;

// the list of all Displayable objects to draw
class Scene;
extern Scene *scene;

// the list of all Lights which should be drawn
class LightList;
extern LightList *lights;

// the list of all color objects (including material definitions)
class ColorList;
extern ColorList *colors;

// axes and stage used in the scene
class Axes;
extern Axes *axes;
class Stage;
extern Stage *stage;

// the command processor
class CommandQueue;
extern CommandQueue *commandQueue;

// collection of all user interface objects
class UIList;
extern UIList *uiList;

// the text interface
class UIText;
extern UIText *uiText;

// the mouse used to manipulate the objects
class Mouse;
extern Mouse *mouse;

// the global lists of all tools and trackers in maintained in UIVR
class UIVR;
extern UIVR *uiVR;

// the global list of all molecules
class MoleculeList;
extern MoleculeList *moleculeList;

// the global list of geometry labels
class GeometryList;
extern GeometryList *geometryList;

// current remote setup object (only one is active at a time), and list of
// running simulations
#ifdef VMDREMOTE
class Remote;
extern Remote *remote;
class RemoteList;
extern RemoteList *remoteList;
#endif

// this allow text commands to be sent in via PVM messages
#ifdef VMDEXTERNAL
class UIExternal;
extern UIExternal *uiExternal;
#endif

// resource to hold configuration values from a file
class ConfigList;
extern ConfigList *configList;

// the different ways to record a scene to a file in some format
class FileRenderList;
extern FileRenderList *fileRenderList;

/////////////////////////  external functions  

// initialize the global variables and objects for the general library.
// Must be passed command-line arguments to program.  Creates graphics
// context and all associated objects, and then starts the UI, then adds any
// commands that should be done at start.  When done, flushes command queue
// and then returns, when the program is ready to start main event loop.
extern void VMDinit(int, char *[]);

// initialize the user interface ... called by VMDinit at start
extern void VMDinitUI(void);

// print out title message
extern void VMDtitle(void);

// given a string, return a new one with the temp dir name prepended.
// This will use an internal static buffer, so it is NOT reentrant.
extern char *VMDtempFile(const char *);

// given a string, start up a HTML viewer with the string as an argument.
// Return success.
extern int VMDreadHTML(char *);

// redraw the screen and update all things that need updatin'
extern int VMDupdate(int);

// exit the program normally with a message and exit code
extern void VMDexit(char *, int);

// exit the program abnormally with a message
extern void VMDdie(char *);

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: Global.h,v $
 * Revision 1.19  1995/05/13  01:36:00  billh
 * Help is now displayed by launching an HTML viewer (Mosaic by default)
 * which will display the file /usr/local/lib/vmd/vmd_help.html
 *
 * Revision 1.18  95/05/11  22:50:17  billh
 * Uses new Mouse constructor; uiVR now created in Global; added VMDGL
 * option to allow separate specification of GUI and graphics methods.
 * 
 * Revision 1.17  95/04/06  17:54:50  dalke
 * Finished interface
 * 
 * Revision 1.16  1995/04/04  21:05:44  billh
 * Added VMDTMPDIR env variable, and routine VMDgetEnvironment for
 * processing env variables.  Made global char string myTempDir to
 * hold a directory for temporary files, and routine VMDtempFile to
 * generate a temp filename from just a single string.
 *
 * Revision 1.15  95/03/24  18:50:04  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.14  1995/03/04  05:13:15  billh
 * Added geometry menu.
 *
 * Revision 1.13  1995/02/22  08:43:51  dalke
 * added uiExternal
 *
 * Revision 1.12  1994/11/24  07:27:03  dalke
 * Added fileRenderList
 *
 * Revision 1.11  1994/11/02  05:18:27  dalke
 * Added configList read from .vmd_init files
 * Added configList option to turn off the title
 *
 * Revision 1.10  1994/10/28  18:36:05  billh
 * Updated due to conversion of Mouse to a general base class.  Window
 * events have also been made non-GL-specific.
 *
 * Revision 1.9  1994/10/21  03:49:55  billh
 * Added remoteList global variable, and sim control menu.
 *
 * Revision 1.8  1994/10/05  04:38:23  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.7  1994/10/01  03:09:18  billh
 * Improved setup of compiler directives.  Now the VMDFORMS define also
 * refers to using a GLDisplayDevice.  Also, Mouse object only defined
 * and used if VMDFORMS is defined.
 *
 * Revision 1.6  94/09/30  23:26:41  billh
 * Added remote object reference; soon to add Files menu.
 * 
 * Revision 1.5  1994/09/17  10:08:12  dalke
 * moved trakerList to UIVR, added uiVR
 *
 * Revision 1.4  1994/09/17  09:02:48  billh
 * Put in moleculeList object, and code to create it.
 *
 * Revision 1.3  1994/09/07  07:48:07  dalke
 * added trackerList
 *
 * Revision 1.2  1994/09/06  03:40:56  billh
 * Added code to parse command-line options, and to read init file and
 * startup file (init file processing must still be added).
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
