/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryMol.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.4 $      $Date: 1995/05/11 22:59:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A base class for all Geometry objects which measure information about
 * atoms in a molecule.  A molecule Geometry monitor is assumed to operate
 * on N atoms, and be able to calculate a single floating-point value for
 * those atoms.  (i.e. the angle formed by three atoms in space)
 *
 ***************************************************************************/
#ifndef GEOMETRYMOL_H
#define GEOMETRYMOL_H

#include "Geometry.h"
class MoleculeList;
class Molecule;
class Displayable;


class GeometryMol : public Geometry {

protected:
  // list of molecules to use for data
  MoleculeList *molList;

  // location where to print value in the scene
  float valuePos[3];
  
  // name of molecule geometry monitor
  char *gmName;
  char *uniquegmName;

  //
  // protected functions
  //

  // set the name of this item
  void set_name(void);

  // sort the elements in the list, so that the lowest atom index is first
  // (but preserve the relative order, i.e. a-b-c or c-b-a)
  void sort_items(void);

  // check whether the given molecule m & atom index a is OK
  // if OK, return Molecule pointer; otherwise, return NULL
  Molecule *check_mol(int m, int a);

  // for the given Molecule, find the TRANSFORMED coords for the given atom.
  // return Molecule pointer if successful, NULL otherwise.
  Molecule *transformed_atom_coord(int m, int a, float *);
  
  // for the given Molecule, find the UNTRANSFORMED coords for the given atom.
  // return Molecule pointer if successful, NULL otherwise.
  Molecule *normal_atom_coord(int m, int a, float *);

  // draws a line between the two given points
  void display_line(float *, float *, Displayable *);

  // print given text at current valuePos position
  void display_string(char *, Displayable *);

public:
  // constructor: # items, molecule list to use
  GeometryMol(int, int *, int *, MoleculeList *mlist);
  virtual ~GeometryMol(void);
  
  //
  // public virtual routines
  //
  
  // return the name of this geometry marker; by default, just blank
  virtual char *name(void);

  // return 'unique' name of the marker, which should be different than
  // other names for different markers of this same type
  virtual char *unique_name(void);

  // check whether the geometry value can still be calculated
  virtual int ok(void);

  // calculate a whole list of items, if this object can do so.  Return success.
  virtual int calculate_all(ResizeArray<float> &);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: GeometryMol.h,v $
 * Revision 1.4  1995/05/11  22:59:17  billh
 * Moved log message to end of file.
 *
 * Revision 1.3  95/04/05  19:19:21  billh
 * Fixed problem with specifying atoms to be picked when the name is not 
 * unique ... the full atom name is now of the form "mol_id/atom_index",
 * which is unique for all the atoms in the currently loaded molecules.
 * Users can request an atom with the previous syntax, but that may not
 * get the right atom due to the possibility of have two or more atoms
 * in a single residue have the same atom name.
 * 
 * Revision 1.2  95/03/24  18:50:00  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
