/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryDihedral.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 1995/05/11 22:59:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between four atoms, and draws a marker for the dihedral
 * into the display list for a given Displayable.
 *
 ***************************************************************************/
#ifndef GEOMETRYDIHE_H
#define GEOMETRYDIHE_H

#include "GeometryMol.h"


class GeometryDihedral : public GeometryMol {

public:
  // constructor: molecule id's, atom indices, molecule list
  GeometryDihedral(int *, int *, MoleculeList *);
  
  //
  // public virtual routines
  //
  
  // recalculate the value of this geometry, and return it
  virtual float calculate(void);
  
  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: GeometryDihedral.h,v $
 * Revision 1.3  1995/05/11  22:59:11  billh
 * Moved log message to end of file.
 *
 * Revision 1.2  95/03/24  18:49:52  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
