/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryDihedral.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 1995/05/11 22:59:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between four atoms, and draws a marker for the dihedral
 * into the display list for a given Displayable.
 *
 ***************************************************************************/

#include "GeometryDihedral.h"
#include "MoleculeList.h"
#include "Molecule.h"
#include "utilities.h"


////////////////////////  constructor  /////////////////////////
GeometryDihedral::GeometryDihedral(int *m, int *a, MoleculeList *mlist)
	: GeometryMol(4, m, a, mlist) {

}



////////////////////  public virtual routines  //////////////////////

// recalculate the value of this geometry, and return it
float GeometryDihedral::calculate(void) {

  // get coords to calculate distance 
  float pos1[3], pos2[3], pos3[3], pos4[3], r1[3], r2[3], r3[3], r4[3];
  float n1[3], n2[3];
  if(!normal_atom_coord(objIndex[0], comIndex[0], pos1))
    return 0.0;
  if(!normal_atom_coord(objIndex[1], comIndex[1], pos2))
    return 0.0;
  if(!normal_atom_coord(objIndex[2], comIndex[2], pos3))
    return 0.0;
  if(!normal_atom_coord(objIndex[3], comIndex[3], pos4))
    return 0.0;

  subtract(r1, pos1, pos2);
  subtract(r2, pos3, pos2);
  subtract(r3, pos2, pos3);
  subtract(r4, pos4, pos3);
  
  cross_prod(n1, r1, r2);
  cross_prod(n2, r3, r4);
  
  return(geomValue = angle(n1, n2));
}


// draw the geometry marker in the given Displayable's drawing list
void GeometryDihedral::draw_marker(Displayable *d) {
  char valbuf[32];

  // get the transformed positions, and draw a line between them
  float pos1[3], pos2[3], pos3[3], pos4[3];
  if(!transformed_atom_coord(objIndex[0], comIndex[0], pos1))
    return;
  if(!transformed_atom_coord(objIndex[1], comIndex[1], pos2))
    return;
  if(!transformed_atom_coord(objIndex[2], comIndex[2], pos3))
    return;
  if(!transformed_atom_coord(objIndex[3], comIndex[3], pos4))
    return;

  // draw a line into the given Displayable
  display_line(pos1, pos2, d);
  display_line(pos2, pos3, d);
  display_line(pos3, pos4, d);
  
  // print value of distance at midpoint
  midpoint(valuePos, pos2, pos3);
  sprintf(valbuf, "%7.2f", geomValue);
  display_string(valbuf, d);
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: GeometryDihedral.C,v $
 * Revision 1.3  1995/05/11  22:59:10  billh
 * Moved log message to end of file.
 *
 * Revision 1.2  95/03/24  18:49:51  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
