/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GLDisplayDevice.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/05/11 22:49:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of GLRenderer, this object has routines used by all the
 * different display devices that are GL-specific.  Will render drawing
 * commands into a single GL window.
 *
 ***************************************************************************/
#ifndef GLDISPLAYDEVICE_H
#define GLDISPLAYDEVICE_H

#include "GLRenderer.h"

#define GL_STEREO_OFF		0
#define GL_STEREO_CRYSTAL	1
#define GL_STEREO_SIDE		2
#define GL_STEREO_MODES		3


class GLDisplayDevice : public GLRenderer {

private:
  // id number of the GL window
  long windowID;

protected:
  // create a new window and set it's characteristics
  long open_window(char *, int *, int *);

  //
  // stereo routines and data
  //

  // functions used to set perspective for normal or stereo view
  void set_persp(DisplayEye = NOSTEREO);

public:
  // constructor/destructor
  // arguments are the size and location for the window, if known
  GLDisplayDevice(int *size = NULL, int *loc = NULL);
  virtual ~GLDisplayDevice(void);

  //
  // event handling routines
  //

  // queue the standard events (need only be called once ... but this is
  // not done automatically by the window because it may not be necessary or
  // even wanted)
  virtual void queue_events(void);

  // test if there is an event ready
  virtual int test_events(void);

  // read the next event ... returns an event type (one of the above ones),
  // and a value.  Returns success, and sets arguments.
  virtual int read_event(long &, long &);

  //
  // routines to deal with stereo display
  //
  
  // change to a different stereo mode (0 means 'off')
  virtual void set_stereo_mode(int = 0);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual void prepare2D(int do_clear = TRUE);	// ready to draw 2D
  virtual void prepare3D(int do_clear = TRUE);	// ready to draw 3D
  virtual void clear(void);			// erase the device
  virtual void left(void);			// ready to draw left eye
  virtual void right(void);			// ready to draw right eye
  virtual void normal(void);			// ready to draw non-stereo
  virtual void update(int do_update = TRUE);	// finish up after drawing
  virtual void reshape(void);			// refresh device after change
  
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: GLDisplayDevice.h,v $
 * Revision 1.6  1995/05/11  22:49:03  billh
 * Added virtual functions to queue and check events, and to get/modify
 * the cursor position, shape, etc.  All graphics/windowing-specific
 * functions have now been moved to the DisplayDevice.
 *
 * Revision 1.5  95/03/24  18:49:30  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/09/23  00:50:49  billh
 * Now derived from 'GLRenderer'; this level now just contains routines
 * to open a GL window and deal with stereo, projection, etc.
 *
 * Revision 1.3  94/09/03  11:05:29  dalke
 * added a square
 * 
 * Revision 1.2  1994/08/30  07:18:09  dalke
 * Added a triangle command
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
