/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FileRenderer.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/05/11 22:46:02 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The FileRenderer class implements the data and functions needed to 
 * render a scene to a file in some format (postscript, raster3d, etc.)
 *
 ***************************************************************************/
#ifndef FILERENDERER_H
#define FILERENDERER_H

// FileRenderer is a class which allows rendering of graphics to
// files, in the form of commands for other programs (raytracers, etc.) 
// or image formats, or whatever.

#include "DisplayDevice.h"

class FileRenderer : public DisplayDevice {

private:

  // pointer to datablock
  float *dataBlock;
  
  // do we need to tuen antialiasing and depth-cueing on when materials
  // are turned off?
  
  int need_aaon, need_cueon;
  
protected:

  // filename
  
  char fname[255];

  // object color
  
  float currentColor[3];

  // various generic graphics commands

  void set_line_width(int);
  void set_line_style(int);
  void set_color(float *);
  void define_light(int, float *, float *);
  void light_onoff(int, int);
  float scale_radius(float);
  
  // various virtual generic graphics commands

  virtual int do_define_material(int, float *);
  virtual void point(float *);
  virtual void sphere(float *);
  virtual void line(float *, float *);
  virtual void cylinder(float *, float *, float);
  virtual void cone(float *, float *, float);
  virtual void triangle(float *, float *, float *, float *, float *, float *);
  virtual void square(float *, float *, float *, float *, float *);
  virtual void text(char *);
  virtual void text_position(float, float, float);
  virtual void activate_materials(void);
  virtual void deactivate_materials(void);

public:
  
  
  // constructor/destructor
  FileRenderer(char *);
  virtual ~FileRenderer(void);
  
  // set the filename
  void set_filename(char *);
  virtual void prepare3D(int = TRUE) = 0;
  virtual void update(int = TRUE) = 0;
  virtual void render(void *);
   
};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: FileRenderer.h,v $
 * Revision 1.7  1995/05/11  22:46:02  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.6  95/05/10  17:37:05  khamer
 * Fixed line style and width handling
 * 
 * Revision 1.5  1995/05/08  19:42:35  khamer
 * get_matdata was a bad hack.  Got rid of it.
 *
 * Revision 1.4  1995/05/06  20:48:55  khamer
 * Added DisplayDevice& operator=(const DisplayDevice display&);
 *
 * Revision 1.3  1995/05/05  22:24:06  khamer
 * Changed triangle() to use 3 point, 3 normal format.  Added
 *
 * Revision 1.2  1995/05/05  20:33:22  khamer
 * Added empty function definitions for functions that
 * make no sense for raster3d
 *
 * Revision 1.1  1995/05/04  20:36:10  khamer
 * Initial revision
 *
 ***************************************************************************/
