/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FileRenderList.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 22:45:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The FileRenderList class maintains a list of available FileRenderer
 * objects
 *
 ***************************************************************************/

#include "FileRenderList.h"
#include "R3dDisplayDevice.h"


// constructor, start off with the default means of rendering
FileRenderList::FileRenderList(void) {
  add(new R3dDisplayDevice("Raster3D"));
}

// destructor, deallocate all the info
FileRenderList::~FileRenderList(void) {
  for (int i=0;i<renderList.num();i++)
    delete renderList.data(i);
}


// add a new render class with its corresponding name
void FileRenderList::add(FileRenderer *newRenderer) {
  if(newRenderer)
    renderList.add_name(newRenderer->name, newRenderer);
}

// figure out how many render classes are installed
int FileRenderList::num(void) {
  return renderList.num();
}

// return the name for the ith class, returns NULL if out of range
char *FileRenderList::name(int i) {
  if(i>=0 && i < renderList.num()) {
    return renderList.name(i);
  }
  return NULL;
}

// given the name, find the corresponding class (case insensitive search),
// else returns NULL  
FileRenderer *FileRenderList::find(char *rname) {
  int indx = renderList.typecode(rname);
  
  if(indx >= 0)
    return renderList.data(indx);
  else
    return NULL;
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: FileRenderList.C,v $
 * Revision 1.2  1995/05/11  22:45:58  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.1  95/05/04  20:34:23  khamer
 * Initial revision
 * 
 ***************************************************************************/
