/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawMolItem.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.13 $	$Date: 1995/05/11 22:38:07 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Child Displayable component of a molecule; this is responsible for doing
 * the actual drawing of a molecule.  It contains an atom color, atom
 * selection, and atom representation object to specify how this component
 * should look.
 *
 ***************************************************************************/
#ifndef DRAWMOLITEM_H
#define DRAWMOLITEM_H

#include "Displayable.h"
#include "DispCmds.h"
#include "AtomColor.h"
#include "AtomRep.h"
#include "AtomSel.h"
#include "ColorList.h"
class DrawMolecule;


class DrawMolItem : public Displayable3D {

public:
  // atom coloring method to use
  AtomColor *atomColor;
  
  // atom representation to use
  AtomRep *atomRep;
  
  // atom selection to use
  AtomSel *atomSel;

private:
  // parent molecule; kept here as a 'DrawMolecule' pointer for convenience
  DrawMolecule *mol;
  
  // useful drawing command objects, used to create display list
  DispCmdData *dataCmd;		// put in block of data with coordinates
  DispCmdColorIndex cmdColorIndex;
  DispCmdColorRGB cmdColorRGB;
  DispCmdTextPosIndex cmdTextPosIndex;
  DispCmdSphereIndex cmdSphereIndex;
  DispCmdLine cmdLine;
  DispCmdTriangle cmdTriangle;
  DispCmdCylinder cmdCylinder;
  DispCmdText cmdTextX;
  DispCmdMaterials cmdMaterials;
  DispCmdSphereRes cmdSphres;
  DispCmdSphereType cmdSphtype;
  DispCmdLineType cmdLineType;
  DispCmdLineWidth cmdLineWidth;
  
  // put in commands to draw with different representations, using the
  // given positions
  void draw_just_spheres(void);	// used for vdw and dotted reps
  void draw_lines(float *);
  void draw_cpk(float *);
  void draw_points(float *);
  void draw_vdw(void);
  void draw_dotted(void);
  void draw_licorice(float *);
  void draw_bonds(float *);
  void make_connection(float *prev, float *start, float *end, float *next,
		       float radius, int resolution, int is_cyl);
  void draw_spline_curve(int num, float *coords, int *idx,
			 int use_cyl, float b_rad, int b_res);
  void draw_spline_ribbon(int num, float *coords, float *perps,
			  int *idx, int use_cyl, float b_rad,
			  int b_res);
  void draw_tube(float *);
  void draw_ribbons(float *);  // use an external call to 'ribbons'
  
  // regenerate the command list
  void create_cmdlist(void);

  // do we need to completely redraw the list?
  int needRegenerate;

  // do we need to update the current frame coordinates?
  int needNewFrame;

protected:
  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed
  virtual void do_color_changed(ColorList *, int);

public:
  // constructor: parent molecule, and atom drawing methods
  DrawMolItem(DrawMolecule *, AtomColor *, AtomRep *, AtomSel *);
  virtual ~DrawMolItem(void);
  
  // change the atom coloring method.  Return success.
  int change_color(AtomColor *);
  
  // change the atom representation method.  Return success.
  int change_rep(AtomRep *);
  
  // change the atom selection method.  Return success.
  int change_sel(AtomSel *);

  //
  // public virtual routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: DrawMolItem.h,v $
 * Revision 1.13  1995/05/11  22:38:07  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.12  95/04/28  04:47:44  dalke
 * Added 'bonds' and 'points'
 * 
 * Revision 1.11  1995/04/10  09:17:49  dalke
 * updated ribbons code
 *
 * Revision 1.10  1995/04/09  23:23:25  dalke
 * added nucleic acid tube
 *
 * Revision 1.9  1995/04/08  06:38:10  dalke
 * added tube representation
 *
 * Revision 1.8  1995/03/24  18:49:09  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 *
 * Revision 1.7  1994/12/11  01:16:53  dalke
 * Added ribbons - warning - it works, but the render3D interface
 * WILL change
 *
 * Revision 1.6  1994/12/06  08:24:25  billh
 * Added ability to create color categories, due to being now derived from
 * ColorUser.
 * Added routines to have a new color list specified, and to check for when
 * a color in a relevant category is changed.
 *
 * Revision 1.5  94/10/31  23:51:57  billh
 * Uses line width, and added initial versions of CPK and licorice (but they
 * don't yet work).
 * 
 * Revision 1.4  94/10/26  23:22:30  billh
 * Added routines to allow commands to change the settings for the
 * current molecule representation options.
 * 
 * Revision 1.3  94/09/26  18:56:10  billh
 * Added separate list for components (instead of recasting child pointers).
 * Added del_rep routine.
 * 
 * Revision 1.2  94/09/24  20:26:10  billh
 * Added support for color; added routines to setup color index lists,
 * default atom/residue names, and initialization routines.
 * 
 * Revision 1.1  94/09/23  06:01:39  billh
 * Initial revision
 * 
 ***************************************************************************/

