/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DLinkList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/05/11 22:37:54 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Doubly Linked List template, with built-in iterator.
 *
 ***************************************************************************/
#ifndef DLINK_TEMPLATE_H
#define DLINK_TEMPLATE_H


// struct needed to link items together
template<class T>
struct DLink {
  T item;
  DLink<T> *prev;
  DLink<T> *next;
  DLink(const T& a) : item(a) { }
};


template<class T>
class DLinkList {

private:
  // the list, and number of items in list
  DLink<T> *head, *tail, *curr;
  int listItems;
  
public:
  // constructor and destructor
  DLinkList(void);
  ~DLinkList(void);

  //
  // query status of this class
  //
  
  // number of items in this list
  int num(void) { return listItems; }

  // return TRUE if there is a current item
  int is_current(void) { return (curr != ((DLink<T> *)0)); }

  //
  // routines for adding or removing items from the list
  //

  // add new item to end of list
  DLinkList<T>& append(const T&);
  
  // append new item after the current item
  DLinkList<T>& insert_after(const T&);
  
  // append new item before the current item
  DLinkList<T>& insert_before(const T&);
    
  // remove current item from list
  DLinkList<T>& remove(void);
  
  //
  // routines to access a particular item in the list
  //

  // just return the current item, do not change which item is current
  T current(void);

  // return the Nth item; do not change current item position
  T item(int);

  // return the current item, and move the current item on to the next one
  T get(void) { 
    T retval = current();
    next();
    return retval;
  }

  //
  // iterator routines:
  //

  // move the current item pointer to the Nth item
  DLinkList<T>& set(int);
  
  // move the current item pointer to the item which matches the given one
  // return TRUE if found, or FALSE otherwise
  int find(const T&);

  // reset the current item pointer to the beginning of the list
  DLinkList<T>& reset(void) {
    if(head)  curr = head;
    return *this;
  }

  // move the current item pointer to the next item in list
  DLinkList<T>& next(void) {
    if(curr)  curr = curr->next;
    return *this;
  }
  
  // move the current item pointer to the previous item in list
  DLinkList<T>& prev(void) {
    if(curr)  curr = curr->prev;
    return *this;
  }

  // clear the current item pointer; make it null
  DLinkList<T>& clear(void) {
    curr = (DLink<T> *)0 ;
    return *this;
  }

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: DLinkList.h,v $
 * Revision 1.5  1995/05/11  22:37:54  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.4  95/03/24  18:48:49  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1995/01/29  19:57:11  billh
 * Moved almost all in-lined functions to .c file
 *
 * Revision 1.2  94/09/14  03:51:53  billh
 * Added 'insert_before' and 'insert_after' routines.
 * 
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
