/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DLinkList.c,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 22:37:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Doubly Linked List template, with built-in iterator.
 *
 ***************************************************************************/

#include "DLinkList.h"
#include "Inform.h"

////////////////////  constructor
template<class T>
DLinkList<T>::DLinkList(void) {
  MSGDEBUG(1,"Created new DLinkList ..." << sendmsg);

  head = tail = curr = NULL;
  listItems = 0;
}


///////////////////  destructor
template<class T>
DLinkList<T>::~DLinkList(void) {
  // remove all items currently in list, by continually removing the first one
  // until the list is empty
  MSGDEBUG(3,"Deleting DLinkList with " << num() << " items ..." << sendmsg);
  reset();
  while(curr)
    remove();
}

  
///////////////////
///////////////////  public routines
///////////////////


// add new item to end of list
template<class T>
DLinkList<T>& DLinkList<T>::append(const T& a) {
  DLink<T> *newlink = new DLink<T>(a);
  newlink->next = NULL;
  newlink->prev = tail;
  tail = newlink;
  if(newlink->prev)
    (newlink->prev)->next = newlink;
  else
    head = curr = newlink;
  listItems++;
  return *this;
}
  

// append new item after the current item
template<class T>
DLinkList<T>& DLinkList<T>::insert_after(const T& a) {
  if(curr) {		// yes, there is a current item
    DLink<T> *newlink = new DLink<T>(a);
    newlink->next = curr->next;
    newlink->prev = curr;
    curr->next = newlink;
    if(newlink->next == NULL)
      tail = newlink;
    else
      (newlink->next)->prev = newlink;
    listItems++;
  } else		// no current item; just append at end
    append(a);
  return *this;
}


// append new item before the current item
template<class T>
DLinkList<T>& DLinkList<T>::insert_before(const T& a) {
  if(curr) {		// yes, there is a current item
    DLink<T> *newlink = new DLink<T>(a);
    newlink->next = curr;
    newlink->prev = curr->prev;
    curr->prev = newlink;
    if(newlink->prev == NULL)
      head = newlink;
    else
      (newlink->prev)->next = newlink;
    listItems++;
  } else		// no current item; just append at end
    append(a);
  return *this;
}


// remove current item from list
template<class T>
DLinkList<T>& DLinkList<T>::remove(void) {
  DLink<T> *oldlink = curr;
  if(oldlink) {
    if(oldlink->prev)
      (oldlink->prev)->next = oldlink->next;
    if(oldlink->next)
      (oldlink->next)->prev = oldlink->prev;
    if(head == oldlink)
      head = oldlink->next;
    if(tail == oldlink)
      tail = oldlink->prev;
    curr = oldlink->next;
    delete oldlink;
    listItems--;
  }
  return *this;
}


// return the Nth item; do not change current item position
template<class T>
T DLinkList<T>::item(int n) { 
  DLink<T> *link = head;
  while(link && n > 0) {
    link = link->next;
    n--;
  }
  if(link && n == 0)
    return link->item;
  else
    return head->item;	// problem if NO items in list
}


// just return the current item, do not change which item is current
template<class T>
T DLinkList<T>::current(void) {
  DLink<T> *link = curr;
  if(!link) {
    msgErr << "DLinkList error: No current item." << sendmsg;
    link = head;
  }
  return link->item;
}


// move the current item pointer to the Nth item
template<class T>
DLinkList<T>& DLinkList<T>::set(int N) {
  reset();
  for(int i=0; i < N; i++)
    next();
  return *this;
}


// move the current item pointer to the item which matches the given one
// return TRUE if found, or FALSE otherwise
template<class T>
int DLinkList<T>::find(const T& a) {
  reset();
  while(curr && curr->item != a)
    next();
  return (curr != NULL);
}

/* REVISION HISTORY:********************************************************
 *
 * $Log: DLinkList.c,v $
 * Revision 1.3  1995/05/11  22:37:46  billh
 * Moved log messages to the end of the file.
 *
 * Revision 1.2  95/03/24  18:48:48  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/01/29  19:58:41  billh
 * Initial revision
 *
 * Revision 1.2  94/09/14  03:51:53  billh
 * Added 'insert_before' and 'insert_after' routines.
 * 
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
