/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ColorFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 22:10:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu for changing the mapping of names->colors, and the
 * definitions of the colors themselves.
 *
 ***************************************************************************/
#ifndef COLORFORMSOBJ_H
#define COLORFORMSOBJ_H

#include "FormsObj.h"


class ColorFormsObj : public FormsObj {

private:
  // which color category is currently being displayed? (if < 0, none)
  int colorCat;
  
  // which color name is currently being assigned? (if < 0, none)
  int colorName;
  
  // do we need to change the topline for the assigned color browser?
  int resetColorBrowser;

  // fill the color name browser for the color mapping, and select the proper
  // item based on the selection in the color object browser
  void fill_color_name_browser(void);
  
  // fill the color object browser based on the selection in the color category
  // browser
  void fill_color_object_browser(void);

  // reset all the browsers showing the colors to assign
  void reset_color_browsers(void);
  
  // reset the color sliders, based on the current selection in the menu
  void reset_edited_color(void);
  
  // reset the color scale controls
  void reset_color_scale(void);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  ColorFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: ColorFormsObj.h,v $
 * Revision 1.4  1995/05/11  22:10:55  billh
 * Moved log messages to end of file.
 *
 * Revision 1.3  95/03/24  18:48:20  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/12/07  07:48:11  billh
 * Fixed problem with browsers always jumping to the top when a name is
 * selected.
 *
 * Revision 1.1  94/12/06  08:36:55  billh
 * Initial revision
 * 
 ***************************************************************************/
