/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdTrans.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.9 $      $Date: 1995/05/11 22:06:27 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for transforming the current scene.
 *
 ***************************************************************************/
#ifndef CMDTRANS_H
#define CMDTRANS_H

#include "Command.h"

// The following uses the Cmdtypes ROTATE, TRANSLATE, SCALE, ROCKON, ROCKOFF,
// STOPROT from the Command class

// text callback routine for 'rotate', 'translate', 'scale', 'rock'
extern int text_cmd_rotate(int, char **, CommandQueue *, int);
extern int text_cmd_translate(int, char **, CommandQueue *, int);
extern int text_cmd_scale(int, char **, CommandQueue *, int);
extern int text_cmd_rock(int, char **, CommandQueue *, int);


///////////////// rotate the current scene
class CmdRotate : public Command {
public:
  // enum with how to rotate, 'by' or 'to'
  enum { BY, TO };

public:
  // axis to rotate
  char axis;
  
  // amount to rotate
  float deg;
  
  // set, or add to, rotation?
  int byOrTo;
  
  // steps to rotate through; by default this is 1
  int steps;

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // first constructor: a single rotation, no smooth transition
  CmdRotate(float a, char ax, int by_or_to, int newUIid=(-1));
  
  // second constructor: a smooth rotation in given increments ...
  // only useful for "by" rotations.  If "to" is given to this constructor,
  // a single-step rotation is done 
  CmdRotate(float a, char ax, int by_or_to, float inc, int newUIid=(-1));
};


///////////////// translate the current scene
class CmdTranslate : public Command {
public:
  // enum with how to translate, 'by' or 'to'
  enum { BY, TO };

public:
  // amount to translate
  float x, y, z;
  
  // set, or add to, translation?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdTranslate(float nx, float ny, float nz, int by_or_to, int newUIid=(-1));
};


///////////////// scale the current scene
class CmdScale : public Command {
public:
  // enum with how to scale, 'by' or 'to'
  enum { BY, TO };

public:
  // amount to scale
  float s;
  
  // set, or multiply, scaling?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdScale(float ns, int by_or_to, int newUIid=(-1));
};


///////////////// rock the current scene
class CmdRockOn : public Command {
public:
  // axis to rock
  char axis;
  
  // amount to rock
  float deg;

  // steps to rock (if < 0, continuous)
  int steps;

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdRockOn(float a, char ax, int nsteps, int newUIid=(-1));
};


///////////////// stop rocking the current scene
class CmdRockOff : public Command {
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdRockOff(int newUIid=(-1)) ;
};


///////////////// stop rotating (both rocking, and mouse movement) for
///////////////// the current scene
class CmdStopRot : public Command {
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdStopRot(int newUIid=(-1)) ;
};


#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: CmdTrans.h,v $
 * Revision 1.9  1995/05/11  22:06:27  billh
 * Added 'create_text' function to create text representation "on demand".
 * Added text callback functions which are added by UIText, and which are
 * called when a text command is entered and the first word is recognized.
 *
 * Revision 1.8  95/03/31  16:02:51  billh
 * Changed CmdRotate: added ability to rock just once, so that a
 * smooth rotation can be done with a given increment.
 * New form: 'rot x by 50 1' rotates 50 deg about x axis, in 1-deg steps.
 * 
 * Revision 1.7  95/03/24  18:48:14  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.6  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.5  1994/10/03  01:39:42  dalke
 * Took code from .h to .C, leaving only prototypes (to reduce inlining)
 *
 * Revision 1.4  1994/09/30  19:06:51  dalke
 * Took mouse reference out if VMDFORMS not definds
 *
 * Revision 1.3  1994/09/12  20:53:55  billh
 * Added CmdResetView command (RESETVIEW).
 *
 * Revision 1.2  94/08/26  00:00:39  billh
 * Added STOPROT command.
 * 
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
