/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdSigma.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/11 22:06:19 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Command objects for affecting Sigma interface
 *
 ***************************************************************************/
#ifndef CMDSIGMA_H
#define CMDSIGMA_H

#include "Command.h"

// the following defines commands for the Cmdtypes:
// SIGMA_EVENT

// text callback routine for 'sigma'
extern int text_cmd_sigma(int, char **, CommandQueue *, int);


///////////////////// Send an event to Sigma
class CmdSigmaEvent : public Command {
private:
  enum param_type { EV_NO_PARAM, EV_INT_PARAM, EV_ID_PARAM, EV_POINT3_PARAM };

  param_type paramType;
  int event;	// event number
  int param;	// numeric parameter
  int object,	// Id parameter
      element;
  float x,y,z;	// Point3 parameter

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdSigmaEvent(int, int newUIid);
  CmdSigmaEvent(int, int, int newUIid);
  CmdSigmaEvent(int, int, int, int newUIid);
  CmdSigmaEvent(int, float, float, float, int newUIid);
};


#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: CmdSigma.h,v $
 * Revision 1.2  1995/05/11  22:06:19  billh
 * Added 'create_text' function to create text representation "on demand".
 * Added text callback functions which are added by UIText, and which are
 * called when a text command is entered and the first word is recognized.
 *
 * Revision 1.1  95/04/05  20:45:59  billh
 * Initial revision
 * 
 ***************************************************************************/
