/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CaveTracker.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/12 00:39:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A CaveTracker is a device for measuring the 3D spacial position of the
 * Cave input device; it is a subclass of the Tracker class.
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <cave.h>
#include "CaveTracker.h"
#include "Matrix4.h"


// class constructor
CaveTracker::CaveTracker(char *, int ) : Tracker(1) {
	sensorAvailable[0] = TRUE;
	status = TRACKER_OK;
        // get initial position and orientation
        update_sensors();
}

// class destructor
CaveTracker::~CaveTracker(void) {
}

// function to update the sensor positions from the CAVE macros
// the sensor  field is ignored, as is int do_update
// always returns 
int CaveTracker::my_get_data(int , float *x, float *y, float *z,
  float *orient, int ) {

   CAVEGetWand(*x, *y, *z);
   float azi, elev, roll;
   CAVEGetWandOrientation(azi, elev, roll);
   Matrix4 rot;
   rot.rot(azi, 'y');  // from looking at cave.h
   rot.rot(elev, 'x'); // BTW, this is the classical definition of
   rot.rot(roll,'z');  // Euler angles; not the quantum one

   float *or = orient;
   int j, k;
   for(j=0; j < 3; j++)
     for(k=0; k < 3; k++)
       *(or++) = (float)(rot.mat[j][k]);
   return TRUE;
}


/* REVISION HISTORY:********************************************************
 *
 * $Log: CaveTracker.C,v $
 * Revision 1.3  1995/05/12  00:39:29  billh
 * Moved log messages to end of file.
 *
 * Revision 1.2  95/03/24  18:47:34  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/11/08  09:12:12  dalke
 * Initial revision
 *
 * Revision 1.1  1994/09/03  11:18:18  dalke
 * Initial revision
 *
 * Revision 1.8  1994/04/20  23:08:32  billh
 * Fixed RCS header in files to include description; set most files to
 * include Global.h, and not ever main.h.  Global.h includes config.h and
 * utilities.h automatically, as well as Message.h for the output message
 * objects.
 *
 * Revision 1.7  1994/04/16  00:40:21  billh
 * Changed program name to vmd, added RCS header section.
 *
 ***************************************************************************/
