/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CaveDisplayDevice.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.7 $      $Date: 1995/05/11 21:38:26 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * a CAVE specific display device for VMD
 ***************************************************************************/
#ifndef CAVEDISPLAYDEVICE_H
#define CAVEDISPLAYDEVICE_H

#include "GLRenderer.h"
#include "Inform.h"


class CaveDisplayDevice : public GLRenderer {

private:
  // have we initialized the graphics yet?
  int doneGLInit;

  // set up the graphics on the seperate CAVE displays
  void cave_gl_init_fn(void);
  
public:
  // constructor and destructor
  CaveDisplayDevice(void);
  virtual ~CaveDisplayDevice(void);
  
  // whether a button is currently pressed
  virtual int button_down(int);

  // cannot change to stereo mode
  virtual void set_stereo_mode(int = 0);
  
  // routines to prepare, draw, and finish, some done by the CAVE
  virtual void prepare2D(int);
  virtual void prepare3D(int);
  virtual void clear(void);
  
  // special render routine to check for graphics initialization
  virtual void render(void *);

};

#endif

/* REVISION HISTORY:********************************************************
 *
 * $Log: CaveDisplayDevice.h,v $
 * Revision 1.7  1995/05/11  21:38:26  billh
 * Moved log message to end of file.
 * Added button_down virtual function to get the state of the cave buttons,
 * and added include of cave.h
 *
 * Revision 1.6  95/03/24  18:47:20  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 ***************************************************************************/
