#ifndef MDBUFFER_H
#define MDBUFFER_H

class Point3;
class Geometry;
class Id;

const char *md_message_name(int tag);

int  buffer_handshake();
void buffer_set_socket(int fd);
int  buffer_get_socket();

void send_buffer();
void begin_message(int);
void end_message();
void geometry_buffering(int flag);

int  get_event(int *event_num, char **message, int new_read);

void graphics_add_menu(char *title, char **items, int num_items);
void graphics_set_coordinates(Point3 *p, int *from, int *to, int ranges);
void graphics_ready(int low_id, int high_id);
void graphics_results(float val1, float val2);

void geometry_add(Geometry *geom);
void geometry_remove(Id *id);
void geometry_update(Geometry *geom);
void geometry_set_visibility(Id *id, int on);

void buffer_send_event(int event_num);
void buffer_send_event(int event_num, int param1);
void buffer_send_event(int event_num, Id *id);
void buffer_send_event(int event_num, Point3 *p);
void buffer_send_geometry(int event_num, Geometry *geom);

#endif /*MDBUFFER_H*/
