/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIText.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.13 $	$Date: 95/03/24 18:52:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * This is the User Interface for text commands.  It reads characters from
 * the console, and executes the commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	UIText.h,v $
 * Revision 1.13  95/03/24  18:52:28  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.12  1995/03/04  05:14:26  billh
 * Added geomtry labelling commands.
 *
 * Revision 1.11  94/12/06  08:22:44  billh
 * Added color commands.
 * 
 * Revision 1.10  94/11/03  03:41:46  dalke
 * made delay a float
 * 
 * Revision 1.9  1994/11/03  00:14:25  dalke
 * Added the 'wait' command
 *
 * Revision 1.8  1994/10/20  01:32:41  billh
 * Added animation commands.
 *
 * Revision 1.7  1994/10/05  04:38:23  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.6  1994/10/03  08:32:14  dalke
 * Added CmdTool Commands
 *
 * Revision 1.5  1994/10/01  11:01:00  billh
 * Added remote connection commands, put menu parsing commands in a
 * separate routine.
 *
 * Revision 1.4  94/09/17  09:03:30  billh
 * Put in initial molecule commands (load and list).
 * 
 * Revision 1.3  94/09/15  07:03:00  dalke
 * Made tracker text output commands into Commands
 * 
 * Revision 1.2  1994/09/07  07:49:38  dalke
 * added commands to manipulate the trackers via text
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef UITEXT_H
#define UITEXT_H

#include <stdio.h>
#include <string.h>
#include "Stack.h"
#include "UIObject.h"
#include "Command.h"
#include "Timer.h"


class UIText : public UIObject {

private:
  void get_command(char**);
  void read_new_command(char * = NULL);
  int process_command(int, char*[]);
  void add_command_to_queue(char *s);

  // do we need a prompt displayed?  also, functions to indicate we need one,
  // and to actually display it.
  int needPrompt;
  void need_prompt(void) { needPrompt = TRUE; }
  void prompt(void);

  // files to read text from, if not from stdin
  Stack<FILE *> input_files;
  
  // used to delay reading inputs
  Timer mytimer;
  float delay;

  // some functions which process the text before calling the correct command
  int texteval_anim(int argc, char *argv[]);
  int texteval_color(int argc, char *argv[]);
  int texteval_label(int argc, char *argv[]);
  int texteval_menu(int argc, char *argv[]);
  int texteval_molecule(int argc, char *argv[]);
  int texteval_remote(int argc, char *argv[]);
  int texteval_tracker(int argc, char *argv[]);
  int valid_tracker_range(int tracker, int maxtracker);
  int texteval_tool(int argc, char *argv[]);
  int texteval_external(int argc, char *argv[]);

public:  
  // constructor
  UIText(UIList *, CommandQueue *);

  // print out help for this text interface
  void help(void);

  // add the given text command to the queue and process the whole queue.
  void process_text_command(char *);

  // specify new file to read commands from
  void read_from_file(char *);

  //
  // virtual routines for entering/processing commands and events
  //
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  // Arguments are the command type, command object, and the 
  // success of the command (T or F).
  virtual int act_on_command(int, Command *, int);
  
  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);
  
};


/////////////////////////////  Text Event Object  
class TextEvent : public Command {
public:
  // the text command string
  char *cmd;

private:
  // must the string be deleted when the command is done?
  int deleteCmd;

public:
  // constructor; must specify what the text command string is, whether to
  // delete the string storage, and the the ui id
  // This string must be an allocated array
  TextEvent(char *, int = TRUE, int = (-1));

  // destructor; frees up command string memory if necessary
  virtual ~TextEvent(void);
};


#endif
