/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Tool.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.8 $	$Date: 95/03/24 18:52:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  A "tool" is something which:
 *   Uses information from a ToolControl (which gets the tracker/sensor
 * information) to:
 *     1) display some representation  (like an arrow)
 *     2) interact with the environment (like VButtons)
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Tool.h,v $
 * Revision 1.8  95/03/24  18:52:04  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.7  1994/11/07  06:58:05  dalke
 * Added possible future hook for new tools
 *
 * Revision 1.6  1994/10/04  09:04:59  dalke
 * Added needRegenerate (instead of 'detail')
 * moved check_event to .C
 *
 * Revision 1.5  1994/10/03  08:34:10  dalke
 * changed resolution to detail
 * replaced "firstdraw" with an "int detail" so the tool would
 *   redraw every time the info->detail changes
 * fixed the scaling problem
 *
 * Revision 1.4  1994/10/02  10:57:15  dalke
 *   Added unique id for each ToolControl
 *   Move graphical representation to SimpleTool.  None in the base class.
 *
 * Revision 1.3  1994/09/26  07:15:50  dalke
 * Major revisions on how to handle Tools.  Here is the new version.
 * (Old stuff was moved to ToolControl)
 *
 * Revision 1.2  1994/09/17  10:50:38  dalke
 * Added RCS header
 *
 ***************************************************************************/

#ifndef TOOL_H
#define TOOL_H

#include "Scene.h"
#include "Tracker.h"
#include "Buttons.h"
#include "Matrix4.h"
#include "Displayable.h"
#include "DispCmds.h"

typedef struct ToolInfo {
  int toolid;           // number used to determine the tool uniquely
  Tracker *tracker;
  int sensor;
  Buttons *buttons;
  
  float base[3];        // location of the base of the tool (includes offset)
  float tip[3];         // location of the tip
  float orient[9];      // same as the tracker(sensor) orientation
  
  float internal_radius, internal_length;
  float scale;  // size is a scaling factor to turn the above into the below
  float length;           // internal_length * scale
  float radius;           // internal_radius * scale
  int detail;         // 5 is default, 1 is coarse, 10 is detailed
          // as general rules, if your changes wrt detail,
          //  if detail == 1, draw a couple lines
          //  if detail == 3, draw simple ploygons
          //  if detail == 5, draw normal shapes
          //  if detail == 7, more complex shapes, material characteristics
          //  if detail == 9, texture mapping?
          //  if detail == 10, be creative!
};


class ToolControl;  // need this, the two classes are mutually callable

class Tool : public Displayable3D {
protected:
  // graphics commands accesible here for the children
  // these are here for the putdata calls.  The children
  // don't need to new/ make them themselves.
  DispCmdColorIndex drawcolor;
  DispCmdLine drawline;
  DispCmdCone drawcone;
  DispCmdCylinder drawcylinder; 
  DispCmdMaterials drawmaterials;

  int tip_checking;  // check if tip enters a VRegion

protected:
   // routine to call the VRegions for button presses
  void check_VRegions(float *pos, ToolControl *toolctrl);
    
   //   set up the current graphics rotation matrix
   //   (and save it into the variable "Matrix4 rotataion") and
   //  set the current graphics translation so the _base_ is at
   //   the center(0,0,0)
   //  and compute the new position of the tip
  void do_graphics_transformation(ToolInfo *info);

  // default is to draw a simple pointer - a line
  virtual void redraw_list(ToolInfo *);

public:
  int needRegenerate;   // TRUE when I need to remake the drawlist
                // I initially set this to TRUE
                // to force a remake of the list the first check_event
  void need_regenerate() { needRegenerate = TRUE; }
  
  enum {NONE, HIGHLIGHT, FULL };  // how should I check the VRegion info?
   //   NONE means don't check at all
   //   HIGHLIGHT means check, but don't pass button state info
   //   FULL means check, and if a button is pressed, call the VRegion
  
  Tool(char *name, Scene *sc, int drawlist_size = 1);
  
   // this is called by ToolControl for updating
   //   set up the current graphics rotation matrix
   //   (and save it into the variable "Matrix4 rotataion") and
   //  set the current graphics translation so the _base_ is at
   //   the center(0,0,0)
  virtual void check_event(ToolControl *toolctrl, ToolInfo *info);
  
   // this is the first thing called by the above.  It lets the
   // Tool override anything coming in
  virtual void tool_event(ToolControl *, ToolInfo *);
  
   // should I check if the tip entered a VRegion?
  void tip_check(int check) { tip_checking = check; }
  int tip_check(void) {  return tip_checking; }

   // this is called whenever a button changes state
  virtual void button_event(ToolControl *toolctrl, ToolInfo *info);

   // this is the mechanism by which extensions to the basic tool is made
   // All you do is send the string to the Tool
  virtual void tell(char *);

};

#endif // TOOL_H
