/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ResizeArray.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 95/03/24 18:51:42 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Automatically-adjusting single-dim array template.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	ResizeArray.h,v $
 * Revision 1.6  95/03/24  18:51:42  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.5  1995/01/29  19:57:15  billh
 * Moved almost all in-lined functions to .c file
 *
 * Revision 1.4  1994/10/15  19:19:38  billh
 * Took out again the code to provide own allocator/deallocator routines,
 * and added 'insert_before' and 'insert_after' routines.
 *
 * Revision 1.3  94/09/30  19:07:57  dalke
 * Added ability to referecne and external allocator/ deallocator
 * 
 * Revision 1.2  1994/09/26  18:55:28  billh
 * Added remove, append, find, num routines, and currSize variable.
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/

#ifndef RESIZEARRAY_TEMPLATE_H
#define RESIZEARRAY_TEMPLATE_H


template<class T>
class ResizeArray {

private:
  // list of items, and pointer to current item.
  T *data;

  // max number of items that can be stored in the array
  int sz;
  
  // factor by which to make array larger, if must extend
  float resizeFactor;
  
  // largest number of items that have been accessed so far.
  // this is the largest index used, + 1
  int currSize;

public:
  // constructor: initial size of array, and resizing factor (the amount
  //	by which the max array size is multiplied when the array is
  //	indexed beyond it's current size)
  ResizeArray(int, float = 2.0);
  
  // destructor
  ~ResizeArray(void);

  //
  // query routines about the state of the array
  //
    
  // get/set resize factor
  void resize_factor(float f) { resizeFactor = f; }
  float resize_factor(void) { return resizeFactor; }

  // return maximum size of array
  int max_array_size(void) { return sz; }
  
  // largest number of elements that have been accessed
  int num(void) { return currSize; }

  //
  // routines for accessing array elements
  //

  // return the nth item; assume N is >= 0
  T& item(int);
  
  // [] operator version of the item() routine
  T& operator[](int N) { return item(N); }

  // add a new element to the end of the array.  Return index of new item.
  int append(const T& val) {
    item(currSize) = val;
    return currSize - 1;
  }

  // insert new item after the specified index.  Return index of new item.
  // if specified index is < 0, item put at beginning of list.
  // if specified index is >= num(), item put at end of list.
  int insert_after(int, const T&);

  // insert new item before the specified index.  Return index of new item.
  // if specified index is < 0, item put at beginning of list.
  // if specified index is >= num(), item put at end of list.
  int insert_before(int, const T&);

  // remove the Mth ... Nth items: move all items lower in the
  // array up to fill the empty slots.
  // If both arguments are < 0, removes ALL items.
  // If the second argument is < 0, just removes item m
  void remove(int = (-1), int = (-1));
  
  // scan the array until the first item that matches in the array is
  // found.  Return the index if found, (-1) otherwise.
  int find(const T&);

};

#endif
