/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PointerTool.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 95/03/24 18:51:19 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Source code that lets me point things out, change size/detail/ etc.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	PointerTool.C,v $
 * Revision 1.5  95/03/24  18:51:19  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/10/05  04:38:59  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.3  1994/10/04  09:05:34  dalke
 * Added button controls for length/size/detail
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/PointerTool.C,v 1.5 95/03/24 18:51:19 billh Exp $";
#endif
#include "CommandQueue.h"
extern CommandQueue *commandQueue;
#include "Tool.h"
#include "ToolControl.h"
#include "PointerTool.h"
#include "Buttons.h"
#include "CmdTool.h"


////////////////////////////  constructor
PointerTool::PointerTool(char *name, Scene *sc, int drawlist_size) 
	: Tool(name, sc, drawlist_size) {
  tip_checking = FULL;
  modification_state = LENGTH;
  direction_state = INCREASE;
}

///////////////////////////  destructor
PointerTool::~PointerTool(void) {
  // does nothing
}


///////////////////////////  member routines  //////////////////////////
void PointerTool::redraw_list(ToolInfo *info)
{
  
  reset_disp_list();  // clear out everything
  
  // the default picture is a simple cylinder with a cone end
  switch (info->detail ) {
    case 1:  // draw a simple line with a cheap end
       {float tip[3]  = {1,0,0}; 
       float base[3] = {0,0,0};
       drawcolor.putdata(info -> toolid, this);  // color each tool differently
       drawline.putdata(base, tip, this);  // line
        base[0] = 0.9;
        base[1] = 0.1;
       drawcolor.putdata(info -> toolid + 1, this);
        drawline.putdata(base, tip, this);  // and tip
        base[1] = -base[1];
        drawline.putdata(base, tip, this);
        base[2] = base[1];
        base[1] = 0.0;
        drawline.putdata(base, tip, this);
        base[1] = -base[1];
        drawline.putdata(base, tip, this);}
      break;
    case 2:  // draw a cylinder with different sized radii
       draw_cylindrical_pointer(info, 3);
      break;
    case 3:
       draw_cylindrical_pointer(info, 4);
      break;
    case 4:
       draw_cylindrical_pointer(info, 6);
      break;
    case 5:
       draw_cylindrical_pointer(info, 10);
      break;
    case 6:
       draw_cylindrical_pointer(info, 16);
      break;
    case 7:  // include material characteristics
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 8:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 9:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 16);
       drawmaterials.putdata(FALSE, this);
      break;
    case 10: 
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 24);
       drawmaterials.putdata(FALSE, this);
      break;
    default:  // same as 5
       draw_cylindrical_pointer(info, 10);
      break;
  }
}

//
//                     (x=.7142 == 1-(1-.8)(1.0/.7)  , r=1*radius)
//                    )
//   ------------------)  (x=.8*len, r=0.7*radius)
//                      )
//                       )  ( x = 1, r = 0)
void PointerTool::draw_cylindrical_pointer(ToolInfo *info, int numsides)
{
  if (numsides < 3) numsides = 3;
  if (numsides > 30) numsides = 30;
  float base[3] = {0.0,0.0,0.0};
  float tip[3] = {0.8, 0.0, 0.0};
  drawcolor.putdata(info -> toolid, this);  // color each tool differently
  drawcylinder.putdata(base, tip, 0.7, numsides, this);
  base[0] = 1.0-(1.0-.8)/.7;
  tip[0] = 1.0;
  drawcolor.putdata(info -> toolid + 1, this);
  drawcone.putdata(base, tip, 1, numsides, this);
}

// sniff if button 0 is down.
// If so, increase/decrease the value of whichever state accordingly
void PointerTool::tool_event(ToolControl *toolctrl, ToolInfo *toolinfo)
{
  Buttons *checkbuttons;
  if ( checkbuttons = toolinfo -> buttons) {
    if (checkbuttons -> button(0) ) {
      if (modification_state == LENGTH) {
        if (direction_state == INCREASE)
          commandQueue -> append(new CmdToolSetSize(
                             toolinfo -> toolid,
                             0, // scale
                             toolctrl -> length() * 1.05,
                             0, // detail
                             -1 )); // I ain't a UI
         else
          commandQueue -> append(new CmdToolSetSize(
                             toolinfo -> toolid, 0, 
                             toolctrl -> length() * (1.0/1.05), 0, -1 ));
      } else if (modification_state == SCALE) {
         if (direction_state == INCREASE)
            commandQueue -> append(new CmdToolSetSize(toolinfo -> toolid,
                   toolctrl -> scale() * 1.05, 0, 0, -1 ));
          else
            commandQueue -> append(new CmdToolSetSize(toolinfo -> toolid,
                   toolctrl -> scale() * (1.0/1.05), 0, 0, -1 ));
      } else if (modification_state == DETAIL) {
         if (direction_state == INCREASE)
            commandQueue -> append(new CmdToolSetSize(toolinfo -> toolid,
                   0, 0, toolctrl -> detail()+1, -1 ));
          else
            commandQueue -> append(new CmdToolSetSize(toolinfo -> toolid,
                   0, 0, toolctrl -> detail()-1, -1 ));
      }
    }
  }
}


// check which button was pushed, and change the appropriate state 
void PointerTool::button_event(ToolControl *, ToolInfo *info)
{
  Buttons *checkbuttons;
  if (!(checkbuttons=info -> buttons))
    return;
  
  // if button 0 was released, change the direction
  if (checkbuttons -> change(0) == -1) {
    direction_state = (direction_state == DECREASE ? INCREASE : DECREASE);
  }
  // if button 1 was pressed, go through possible modification states
  if (checkbuttons -> change(1) == 1) {
    switch(modification_state) {
      case SCALE: modification_state = DETAIL; break;
      case DETAIL:modification_state = LENGTH; break;
      case LENGTH: 
      default:modification_state = SCALE; break;
    }
  }
}
