/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PickModeQuery.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:51:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PickModeQuery is a special PickMode which just queries what kind of
 * object the item picked is.  If the mouse is pressed and released without
 * any movement, the name of the Displayable is simply printed to the console.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	PickModeQuery.h,v $
 * Revision 1.2  95/03/24  18:51:14  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/22  03:56:04  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef PICKMODEQUERY_H
#define PICKMODEQUERY_H

#include "PickMode.h"


class PickModeQuery : public PickMode {

private:
  // Pickable we're currently querying.
  Pickable *pQuery;
  
  // pointer coords when this started
  float pPos[3];

  // need printout of name
  int needName;

public:
  // constructor & destructor: don't do much at all
  PickModeQuery(void);
  
  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  // called when a pick is begun:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick moves:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick ends:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *,
  				Pickable *, int, int, int, float *);
};

#endif
