/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeRemote.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 95/03/24 18:50:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeRemote is inherited from Molecule and contains a Remote;
 * it is a Molecule which is representing a remote simulation, from which
 * it gets parameters and coordinates.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	MoleculeRemote.h,v $
 * Revision 1.5  95/03/24  18:50:55  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/11/10  17:20:31  billh
 * Added option to save every Nth transferred frame.
 * Now reads in data about patch status from mdcomm fields.
 *
 * Revision 1.3  94/11/09  02:50:28  billh
 * Added finished support for displaying patches for a remote molecule.
 * 
 * Revision 1.2  94/10/21  03:51:59  billh
 * Added initial support for patch configuration display, and fixed some bugs.
 * 
 * Revision 1.1  1994/10/01  11:04:31  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef MOLECULEREMOTE_H
#define MOLECULEREMOTE_H

#include "Molecule.h"
#include "Remote.h"
extern class DrawPatch;


class MoleculeRemote : public Molecule {

public:
  // our remote connection
  Remote *rem;

private:
  // name of path and filename containing structure of molecule
  char *strName, *strPath;

  // number of the timestep we're currently at
  int Step;

  // number of frames we've received from remote connection
  int framesReceived;

  // does this molecule have any patch data?
  int hasPatchDisplay;

  // patch display representation
  DrawPatch *drawPatch;

  // do main constructor tasks
  void do_construct(Remote *);

  // create structure from remote connection data
  int createFromRemote(Remote *);

public:
  // class constructor/destructor
  MoleculeRemote(Remote *, Scene *);
  MoleculeRemote(Remote *, Displayable *);
  virtual ~MoleculeRemote(void);

  // current step of simulation
  int step(void) { return Step; }

  // return the path and name of this molecule
  virtual char *file_path(void);
  virtual char *file_name(void);

  //
  // routines for displaying patch data (if available)
  // static data about names for display methods found at end of this file
  //

  // return whether this molecule has any patch data to display
  int has_patch_display(void) { return hasPatchDisplay; }

  // get/change the method for displaying patches
  int patch_display_method(void);
  int patch_display_method(int);

  //
  // public virtual routines for Molecule
  //
  
  // creates the molecule, using the info provided in the constructor.
  // returns success, and also calls parent class create routines
  virtual int create(void);


  //
  // public virtual routines for Displayable
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  //  ... this updates the animation
  virtual void prepare(DisplayDevice *);

};

#endif
