/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFilePSF.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:50:48 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read the molecule information from a PSF file
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	MoleculeFilePSF.h,v $
 * Revision 1.2  95/03/24  18:50:48  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef MOLECULEFILEPSF_H
#define MOLECULEFILEPSF_H
#include "MoleculeFile.h"

// Note that the reference to:
//  the textual description: in MoleculeFile
//  the constructor: in CmdMol.C
//
class MoleculeFilePSF : public MoleculeFile
{
 private:
  // read in the molecular data from the specified PSF file
  int createFromPSF(char *psffile);

 public:
   MoleculeFilePSF(char *, Scene *);
   MoleculeFilePSF(char *, Displayable *);
   virtual ~MoleculeFilePSF(void);

   // creates the molecule and returns success - also calls
   // the parent class create routines
   virtual int create(void);
};

#endif
