/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: LightList.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/03/24 18:50:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of Light objects; used to select a single active one and allow
 * the user to manipulate it.  Also provides an initial set of default lights.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	LightList.C,v $
 * Revision 1.3  95/03/24  18:50:20  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1995/01/30  21:02:56  billh
 * No longer derived from DLinkList; but routines put in to make it
 * LOOK like it is one, so the rest of the vmd code does not have to
 * be changed.  Now it just uses a simple array to store the Light
 * pointers, which is smaller and faster.
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifdef ARCH_HPUX
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/LightList.C,v 1.3 95/03/24 18:50:20 billh Exp $";
#endif

#include "LightList.h"
#include "Light.h"
#include "Scene.h"
#include "Matrix4.h"
#include "Inform.h"

// default light data
static float def_light_color[3] = { 1.0, 1.0, 1.0 };
static float def_light_pos[MAX_DISP_LIGHTS][3] = { 
	{ -0.1, 0.1, 1.0 }, { 1.0, 2.0, 0.5 },
	{ -1.0, 2.0, -1.0 }, { -1.0, -1.0, 0.0 }
};


// constructor: create lights with default values, and add to self
LightList::LightList(Scene *sc) {

  // set the number of lights to have in this list
  numLights = MAX_DISP_LIGHTS;

  MSGDEBUG(1,"Creating LightList, with " << numLights << " lights.");
  MSGDEBUG(1,sendmsg);

  // create lights, with default values
  for(int i=0; i < numLights; i++)
    ltList[i] = new Light(sc, i, def_light_color, def_light_pos[i]);

  // make light 0 the current light
  reset();
}


// destructor: delete lights in list
LightList::~LightList(void) {
  MSGDEBUG(1,"Deleting LightList, with " << numLights << " lights.");
  MSGDEBUG(1,sendmsg);

  for(int i=0; i < numLights; i++)
    delete ltList[i];
}


// apply rotations to the current light, if any
void LightList::add_rot(float x, char axis) {
  if(!is_current())
    return;
    
  current() ->add_rotation(x, axis);
}

// apply rotations to the current light, if any
void LightList::add_rot(Matrix4 &m) {
  if(!is_current())
    return;
    
  current() ->add_rotation(m);
}

// apply rotations to the current light, if any
void LightList::set_rot(Matrix4 &m) {
  if(!is_current())
    return;
    
  current() ->set_rotation(m);
}

