/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Light.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 95/03/24 18:50:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A Displayable3D object which represents a light source at infinity, along
 * some line from the origin, of some color.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Light.h,v $
 * Revision 1.7  95/03/24  18:50:18  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.6  1994/11/02  01:35:38  billh
 * Highlight drawn with dotted line of width 3.
 *
 * Revision 1.5  94/10/01  03:03:59  billh
 * Removed 'update' routine.
 * 
 * Revision 1.4  94/09/28  17:19:27  billh
 * Added command to check if highlighted.
 * 
 * Revision 1.3  94/09/24  20:09:30  billh
 * Now contain single display commands which are used many times,
 * instead of re-creating and destroying disp command objects.
 * 
 * Revision 1.2  1994/09/12  20:52:01  billh
 * Changed due to changes in Displayable constructor arguments.
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef LIGHT_H
#define LIGHT_H

#include "Displayable.h"
#include "DisplayDevice.h"
#include "DispCmds.h"
#include "Matrix4.h"


class Light : public Displayable3D {

public:
  // color of the light defining the axes
  float color[3];
  
  // position of the light (rotated from this position by value of trans mat)
  float pos[3];

private:
  // is the light on or off?
  int lightOn;

  // is the light highlight on or off?
  int highlightOn;

  // do we need to define the light? or to turn it on/off?
  int need_define, need_onoff, need_highlight;

  // do we need to clean up after a draw where colors were defined?
  int needDefineCleanup;

  // which light we are
  int num;

  // regenerate the command list
  void create_cmdlist();

  // identity matrix for this to use
  Matrix4 ident;

  // load matrix command
  DispCmdLoad *loadIdentMat;

  // useful display commands
  DispCmdLightDef deflight;
  DispCmdLightOnOff onofflight;
  DispCmdColorRGB hcol;
  DispCmdLine hline;
  DispCmdTextPos htxtpos;
  DispCmdText htxt;
  DispCmdLineType cmdLineType;
  DispCmdLineWidth cmdLineWidth;

public:
  // constructor: the Scene to register this with, the light number,
  // the color, and the position
  Light(Scene *, int, float *, float *);
  virtual ~Light(void);

  // indicate we must change the current settings
  void redefine(void) { need_define = TRUE; }

  // set if we are highlighting
  int light_highlighted(void) const { return highlightOn; }
  void highlight(int h) { highlightOn = h; need_highlight = TRUE; }

  // override the on/off commands since the light will always need to be
  // taken care of
  int light_displayed(void) const { return lightOn; }
  virtual void off(void);
  virtual void on(void);

  // special rotation commands for this object the rotating commands
  void add_rotation(float x, char axis);
  void add_rotation(Matrix4 &);
  void set_rotation(Matrix4 &);

  //
  // public virtual routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

};

#endif
