/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: Geometry.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.2 $      $Date: 95/03/24 18:49:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The base class for all objects which measure the geometry of some item
 * such as a molecule.  Each Geometry object is assumed to measure info
 * between N items, where each item is the ith component in an object j.
 * The geometry object must be able to calculate a value for these items,
 * and must have the ability to draw a marker representing the geometry and
 * it's value to a Displayable's drawing list.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Geometry.h,v $
 * Revision 1.2  95/03/24  18:49:41  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef GEOMETRY_H
#define GEOMETRY_H

#include "ResizeArray.h"
extern class Displayable;


class Geometry {

protected:
  // number of components used to calculate the geometry value
  int numItems;
  
  // indices of objects which contain the components, and indices of components
  int *objIndex;
  int *comIndex;
  
  // most recent value
  float geomValue;
  
  // is this geometry marker on or off?
  int isOn;

  // do we have a useful value to print?
  int hasValue;

public:
  // constructor: # items; rest must be put in by derived class constructors
  Geometry(int);
  
  // destructor: free up spaced used
  virtual ~Geometry(void);
  
  //
  // public information routines
  //
  
  // number of items in this object
  int items(void) { return numItems; }
  
  // most recent value
  float value(void) { return geomValue; }

  // do we have a useful value to print?
  int has_value(void) { return hasValue; }

  // get/set status of whether to show this geometry monitor
  int on(void) { return isOn; }
  void on(int newon) { isOn = newon; }

  //
  // public virtual routines
  //
  
  // return the name of this geometry marker; by default, just blank
  virtual char *name(void);

  // recalculate the value of this geometry, and return it
  virtual float calculate(void);
  
  // calculate a whole list of items, if this object can do so.  Return success.
  virtual int calculate_all(ResizeArray<float> &);

  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);

  // check whether the geometry value can still be calculated
  virtual int ok(void);

};

#endif
