/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: Geometry.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 95/03/24 18:49:40 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The base class for all objects which measure the geometry of some item
 * such as a molecule.  Each Geometry object is assumed to measure info
 * between N items, where each item is the ith component in an object j.
 * The geometry object must be able to calculate a value for these items,
 * and must have the ability to draw a marker representing the geometry and
 * it's value to a Displayable's drawing list.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Geometry.C,v $
Revision 1.1  95/03/24  18:49:40  billh
Initial revision

 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/Geometry.C,v 1.1 95/03/24 18:49:40 billh Exp $";
#endif

#include "Geometry.h"
#include "utilities.h"

//////////////////////////  constructor
Geometry::Geometry(int n) {
  objIndex = new int[n];
  comIndex = new int[n];
  geomValue = 0.0;
  numItems = n;
  isOn = hasValue = TRUE;
}


////////////////////////// destructor: free up spaced used
Geometry::~Geometry(void) {
  delete [] objIndex;
  delete [] comIndex;
}


///////////////////////  public virtual routines  ///////////////////////////
  
// return the name of this geometry marker; by default, just blank
char *Geometry::name(void) { return ""; }

// recalculate the value of this geometry, and return it
float Geometry::calculate(void) { return 0.0; }
  
// calculate a whole list of items, if this object can do so.  Return success.
int Geometry::calculate_all(ResizeArray<float> &) { return FALSE; }

// draw the geometry marker in the given Displayable's drawing list
void Geometry::draw_marker(Displayable *) { }

// check whether the geometry value can still be calculated
int Geometry::ok(void) { return TRUE; }

