/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 95/03/24 18:49:26 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The FORMS object, which is one single form that can be turned on/off,
 * initialized, etc  It is a base class for specific
 * forms.  It assumes that this is for use with a MoleculeList, and will
 * use the specified DisplayDevice.
 * This class is derived from UIObject; it can generate and receive commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	FormsObj.h,v $
 * Revision 1.6  95/03/24  18:49:26  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.5  1994/10/19  20:23:08  billh
 * Made 'On' and 'Off' virtual routines in every UIObject, and added virtual
 * routine 'is_on' to test for whether the ui is on or off (used mainly by
 * Mouse to provide options to toggle forms on and off)
 *
 * Revision 1.4  1994/10/05  04:37:15  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.3  1994/09/29  07:10:48  billh
 * Made act_on_command call protected virtual forms_act_on_command so that
 * forms versions of these objects get updated after a command properly.
 *
 * Revision 1.2  94/09/17  09:02:01  billh
 * Returned code to deal with working with moleculeList and Molecules.
 * 
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef FORMSOBJ_H
#define FORMSOBJ_H

#include "Global.h"
#include "UIObject.h"
#include "Command.h"
#include "Molecule.h"

// include FORMS headers
extern "C" {
#include <forms.h>
#include "forms_ui.h"
}


class FormsObj : public UIObject {

private:
  // flags for whether the form is on screen
  int formShowing;

  // should the form be placed by hand, or at the given location?
  int placeMethod;

  // where to put the form if a specific location has been given
  int formPosition[2];

  // whether to show the window border
  int border;

  // static element which tells whether the forms have been initialized
  static int formsInitialized;
  
  // static element which tells whether we need to check for new events
  static int checkNewEvents;
  
protected:
  // pointer to the form this object is for ... must be assigned by derived
  // class, because 'create_the_forms' must be called before any global forms
  // pointers are initialized.
  FL_FORM *form;

  // common forms elements; if NULL, the form does not have that element
  FL_OBJECT *lightButton;	// lighted On/Off button
  FL_OBJECT *offButton;		// simple off-button (when pressed, hide menu)

  // molecule this form is currently working with - the "top" molecule
  // This is not really necessary, just a convenience.
  Molecule *mol;

  // set the precision for an integer input box
  void set_input_int(FL_OBJECT *, int, int);
  
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *) = 0;
  
  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  FormsObj(char *, UIList *,CommandQueue *, int, int * = NULL);
  virtual ~FormsObj(void);

  // freeze/thaw the form
  void freeze(void) { fl_freeze_form(form); }
  void unfreeze(void) { fl_unfreeze_form(form); }

  // move the form to the given position
  void move(int, int);

  // return the current location of the form
  void where(int& x, int& y) {
    x = (int)(form->x);
    y = (int)(form->y);
  }

  // query the form's on/off status
  int displayed(void) { return formShowing; }

  //
  // virtual routines for FORMS-specific options
  //
   
  // turn the form on
  virtual void On(void);

  // turn the form off
  virtual void Off(void);

  // return whether the menu is on
  virtual int is_on(void);

  //
  // virtual routines to provide information about the UIObject
  //

  // is this a menu object?
  virtual int is_menu(void);
   
  //
  // virtual routines for UI init/display
  //
   
  // update the displays
  virtual void update(void);

  //
  // virtual routines for entering/processing commands and events
  //
  
  // update the display due to a command being executed.  Return whether
  // any action was taken on this command.
  // Arguments are the command type, command object, and the 
  // success of the command (T or F).
  virtual int act_on_command(int, Command *, int);
  
  // check for an event, and queue it if found.  Return TRUE if an event
  // was generated.
  virtual int check_event(void);
  
};

/////////////////////////////  GUI Event Object  
class GUIEvent : public Command {
public:
  // the forms object that was changed
  FL_OBJECT *obj;

public:
  // constructor; must specify what the event type code is
  GUIEvent(FL_OBJECT *o, int newUIid=(-1))
    : Command(Command::GUI_EVENT, newUIid) {
    obj = o;

    *cmdText << "# GUI event '" << (long)obj << "'" << ends;
  }
};


#endif
