/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawMolecule.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.9 $	$Date: 95/03/24 18:49:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Displayable version of a DrawMolecule, derived from BaseMolecule and
 * Displayable3D.  This contains all the info for rendering
 * the molecule.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	DrawMolecule.h,v $
 * Revision 1.9  95/03/24  18:49:12  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.8  1995/03/04  05:11:47  billh
 * Added routine atom_displayed, which should return a T/F value
 * indicating if the given atom is being displayed by any of the
 * current representations.  For now, as a quick hack, it always
 * returns true; this must be updated in the future.
 *
 * Revision 1.7  95/02/12  07:20:34  dalke
 * migrated stuff to virtual, and made DrawMolecule be 3D
 * 
 * Revision 1.6  1994/10/26  23:23:10  billh
 * Added routines to allow commands to change the settings for the
 * current molecule representation options.
 *
 * Revision 1.5  94/10/01  03:03:59  billh
 * Removed 'update' routine.
 * 
 * Revision 1.4  94/09/26  18:56:53  billh
 *  Added separate list for components (instead of recasting child pointers).
 * Added del_rep routine.
 * 
 * Revision 1.3  94/09/24  20:26:08  billh
 * Added support for color; added routines to setup color index lists,
 * default atom/residue names, and initialization routines.
 * 
 * Revision 1.2  94/09/23  00:46:23  billh
 * Added ability to add new representations (DrawMolItem objects) as children.
 * 
 * Revision 1.1  94/09/17  09:11:36  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef DRAWMOLECULE_H
#define DRAWMOLECULE_H

#include "BaseMolecule.h"
#include "Displayable.h"
#include "DrawMolItem.h"
#include "ResizeArray.h"
#include "DispCmds.h"
extern class AtomColor;
extern class AtomRep;
extern class AtomSel;


class DrawMolecule : public BaseMolecule, public Displayable3D {

public:
  // is this molecule active?  Used by MoleculeList.
  int active;

  // routine to set the name of the molecule
  virtual void set_name(char *);
  
private:
  // does this molecule require a redraw during the prepare phase?
  int needRedraw;
  
  // representations
  ResizeArray<DrawMolItem *> repList;

protected:
  // regenerate the command list
  virtual void create_cmdlist(void);

private:
  // useful drawing commands
  DispCmdData dataCmd;		// put in block of data with coordinates
  DispCmdText cmdTxt;
  DispCmdMaterials cmdMaterials;
  DispCmdLineWidth cmdLineWidth;
  DispCmdColorIndex cmdCol;
  DispCmdLineIndex cmdLine;

public:
  // constructor ... nothing to specify.  Must be given either a Scene
  // or another Displayable
  DrawMolecule(Scene *);
  DrawMolecule(Displayable *);
  virtual ~DrawMolecule(void);
  
  // create the molecule.  Successive classes should call their parent 'create'
  // after they are done.
  // Returns success .... if not successful, should be 'delete'ed
  virtual int create(void);

  //
  // public utility routines
  //
  
  // return whether the Nth atom is displayed.  This is true if ANY
  // representation is displaying the given atom
  int atom_displayed(int) { return TRUE; }

  //
  // public virtual routines for Displayable
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  //  ... this updates the animation
  virtual void prepare(DisplayDevice *);

  //
  // access routines for the drawn molecule components (which are the children)
  //
  
  // total number of components
  int components(void) { return repList.num(); }
  
  // return Nth component ... change to proper return type
  DrawMolItem *component(int);

  // delete the Nth representation ... return success
  int del_rep(int);

  // add a new representation (component) ... return success
  virtual int add_rep(AtomColor *, AtomRep *, AtomSel *);

  // change the Nth representation ... return success.
  // if any object is NULL, that characteristic is not changed.
  virtual int change_rep(int, AtomColor *, AtomRep *, AtomSel *);

};

#endif
