/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CoorFile.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/03/24 18:48:39 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Base class for all coordinate files, both for reading and writing.
 * Subclasses must provide methods for opening and closing files,
 * and for reading/writing coordinates.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CoorFile.C,v $
Revision 1.1  95/03/24  18:48:39  billh
Initial revision
 
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CoorFile.C,v 1.1 95/03/24 18:48:39 billh Exp $";
#endif

#include "CoorFile.h"

/////////////////////////////  constructor
// rd = TRUE if file is being read (input), FALSE if being
//	written (output)
CoorFile::CoorFile(int rd) {
  Initialized = FALSE;
  cf = NULL;
  nRemLines = nAtoms = nFrames = currFrames = 0;
  fName = NULL;
  if(!(uName = username()))
    uName = stringdup("");
  isInput = rd;
  errorNo = NO_COOR_ERR;
}

///////////////////////////// destructor
CoorFile::~CoorFile(void) {
  for(int i=(nRemLines - 1); i >= 0; i--)
    delete [] remLines[i];
  if(uName) delete [] uName;
  if(fName) delete [] fName;
}


// initialization routine.  Must be called before reading/writing any frames.
// return TRUE if the file was properly initialized.
int CoorFile::init(char *fn) {
  fName = stringdup(fn);
  return TRUE;
}


/////////////////////////////  ICoorFile routines  ///////////////////////////

// read file header ... by default, does nothing
void ICoorFile::read_header(void) { }


/////////////////////////////  OCoorFile routines  ///////////////////////////

// write file header ... by default, does nothing
void OCoorFile::write_header(void) { }


