/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Command.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/03/24 18:48:26 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     This file contains the base definition of the Command object.
 *  The idea is that all actions should be instantiated as
 *  a derivitive of a Command object and placed in a command queue.
 *  At every event loop, the commands are read off the current command
 *  queue and told to "execute".  When each command
 *  is finished, all of the UIs are notified that a command of some 
 *  "cmdtype" executed, so that the UI can update its information 
 *  if so desired.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Command.C,v $
Revision 1.1  95/03/24  18:48:26  billh
Initial revision

 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/Command.C,v 1.1 95/03/24 18:48:26 billh Exp $";
#endif

#include "Command.h"
#include "Inform.h"
#include "utilities.h"


//////////////////////////////////  constructor
Command::Command(Cmdtype newtype, int newUIid) {
  mytype = newtype;
  UIid = newUIid;
  memset(cmdtextbuf, 0, 256);
  cmdText = new ostrstream(cmdtextbuf, 256);
}


//////////////////////////////////  destructor
Command::~Command(void) {
  delete cmdText;
}


///////////////////////////////  protected routines  /////////////////////////

// virtual function to allow each object to do a different action.
// called by 'execute'.
// By default, does nothing.
int Command::do_execute(void) { return TRUE; }


////////////////////////////////  public routines  ///////////////////////////

// Do the action specified for this command.  Return success.
int Command::execute(void) {
  MSGDEBUG(3,"Executing: '" << *this << "' ..." << sendmsg);
  return do_execute();
}
