/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdUtil.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.4 $      $Date: 95/03/24 18:48:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for doing various utilities, such as executing a shell,
 * displaying help, or quitting
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdUtil.h,v $
 * Revision 1.4  95/03/24  18:48:17  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/10/05  06:58:16  billh
 * Converted to use a ResizeArray instead of a DLinkList in the command queue
 * and ui list.
 *
 * Revision 1.2  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDUTIL_H
#define CMDUTIL_H

#include "Command.h"

// The following uses the Cmdtypes "SHELL", "HELP", "RESET", "DEBUG", and
// "QUIT" from the Command class

//////////// Execute an external command (via the system() call)
class CmdShell : public Command {
public:
  // the command to execute
  char *cmd;

private:
  // single command, or just a shell?
  int justShell;

protected:
  virtual int do_execute(void);

public:
  CmdShell(char *, int=(-1));
  virtual ~CmdShell(void);
};

//////////// display help, in various formats
class CmdHelp : public Command {
public:
  // ways that help can be displayed (currently, only to console)
  enum HelpLoc { HELP_CONSOLE };
    
  // where to display help
  HelpLoc helpLoc;

protected:
  // do the actual action
  virtual int do_execute(void);

public:
  CmdHelp(HelpLoc, int=(-1));
};


//////////// reset all the UI's
class CmdReset : public Command {
private:
  // which UI to reset.  if < 0, reset all
  int resetUI;
    
protected:
  // do the actual action
  virtual int do_execute(void);

public:
  // constructor: which UI to reset, UI id of creator
  CmdReset(int=(-1), int=(-1));
};


//////////// exit the program, possibly asking for confirmation
class CmdQuit : public Command {
private:
  // ask for confirmation?
  int askConfirm;

protected:
  // do the actual action
  virtual int do_execute(void);

public:
  // constructor: confirm quitting, id of creator
  CmdQuit(int, int=(-1));
};


//////////// set the debug level for the program
class CmdDebug : public Command {
public:
  // are we changing the debug level, or turning on/off?
  enum DebugAction { TOGGLE, LEVEL };
  DebugAction action;

  // new debug level, or whether to turn on/off
  int newVal;
    
protected:
  // do the actual action
  virtual int do_execute(void);

public:
  CmdDebug(DebugAction, int, int=(-1));
};


#endif
