/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdUtil.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 95/03/24 18:48:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for doing various utilities, such as executing a shell,
 * displaying help, or quitting
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdUtil.C,v $
Revision 1.1  95/03/24  18:48:16  billh
Initial revision

 * Revision 1.3  1994/10/05  06:58:16  billh
 * Converted to use a ResizeArray instead of a DLinkList in the command queue
 * and ui list.
 *
 * Revision 1.2  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdUtil.C,v 1.1 95/03/24 18:48:16 billh Exp $";
#endif

#include <stdlib.h>
#include <string.h>
#include "CmdUtil.h"
#include "Global.h"
#include "UIList.h"
#include "UIText.h"
#include "DisplayDevice.h"
#include "utilities.h"


//////////// Execute an external command (via the system() call)
CmdShell::CmdShell(char *newcmd,int newUIid) : Command(Command::SHELL,newUIid) {
  char *envtxt;

  justShell = (newcmd == NULL);

  // save copy of the command to execute.  Must append shell command
  if((envtxt = getenv("SHELL")) != NULL) {
    if(newcmd)
      cmd = new char[strlen(newcmd) + strlen(envtxt) + 2];
    else
      cmd = new char[strlen(newcmd) + 1];
    strcpy(cmd,envtxt);
    if(newcmd) {
      strcat(cmd," ");
      strcat(cmd,newcmd);
    }
  } else if(newcmd) {
    cmd = new char[strlen(newcmd) + 4];
    strcpy(cmd,"sh ");
    strcat(cmd,newcmd);
  } else
    cmd = NULL;
      
  *cmdText << "sh";
  if(newcmd)
      *cmdText << " " << newcmd;
  *cmdText << ends;
}

CmdShell::~CmdShell(void) {
  if(cmd) delete [] cmd;
}

int CmdShell::do_execute(void) {
  int retval = FALSE;
  if(cmd) {
    if(justShell)
      msgInfo << "Executing shell (use 'exit' to return) ..." << sendmsg;
    retval = system(cmd);
    if(justShell)
      msgInfo << "\nReturning to program ..." << sendmsg;
  }
  return retval;
}


//////////// display help, in various formats
CmdHelp::CmdHelp(HelpLoc loc, int newUIid) : Command(Command::HELP, newUIid) {
  helpLoc = loc;
}

int CmdHelp::do_execute(void) {
  int retval = FALSE;
  if(helpLoc == HELP_CONSOLE) {
    uiText->help();
    retval = TRUE;
  }
  return retval;
}


//////////// reset all the UI's
CmdReset::CmdReset(int rUI, int newUIid) : Command(Command::RESET, newUIid) {
  resetUI = rUI;
  *cmdText << "reset ";
  if(resetUI < 0)
    *cmdText << "all";
  else if(resetUI >= 0 && resetUI < uiList->num())
    *cmdText << (uiList->item(resetUI))->name;
  *cmdText << ends;
}

int CmdReset::do_execute(void) {
  int retval = TRUE;
  if(resetUI < 0) {
    if(display)
      display->reshape();
    uiList->reset_UI();
  } else if(resetUI >= 0 && resetUI < uiList->num()) {
    (uiList->item(resetUI))->reset();
  } else {
    retval = FALSE;
  }
  return retval;
}


//////////// exit the program, possibly asking for confirmation
CmdQuit::CmdQuit(int confirm, int newUIid) : Command(Command::QUIT, newUIid) {
  askConfirm = confirm;
  *cmdText << "quit";
  if(askConfirm)
    *cmdText << " confirm";
  else
    *cmdText << " now";
  *cmdText << ends;
}

int CmdQuit::do_execute(void) {
  int doexit = TRUE;
  if(askConfirm)
    // for now, does nothing
    ;
  if(doexit)
    VMDexit("Exiting normally", 0);

  return FALSE;		// only get here if confirm = no
}


//////////// set the debug level for the program
CmdDebug::CmdDebug(DebugAction actn, int nval, int newUIid)
	: Command(Command::DEBUG, newUIid) {
  action = actn;
  newVal = nval;
  *cmdText << "debug ";
  if(action == TOGGLE) {
    *cmdText << (nval ? "on" : "off");
  } else if(action == LEVEL) {
    *cmdText << "level " << nval;
  }
  *cmdText << ends;
}

int CmdDebug::do_execute(void) {
  int retval = TRUE;
  if(action == TOGGLE) {
    msgDebug.on(newVal);
  } else if(action == LEVEL) {
    msgDebug.output_level(newVal);
  } else {
    retval = FALSE;
  }
  return retval;
}
