/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTracker.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 95/03/24 18:48:12 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  The Cmds to start and pause a tracker are defined here
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdTracker.h,v $
 * Revision 1.5  95/03/24  18:48:12  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.4  1994/10/04  19:47:15  billh
 * Took out comment from include steaatement
 *
 * Revision 1.3  1994/09/17  09:40:26  dalke
 * fixed delete bug, moved some global variables to UIVR
 *
 * Revision 1.2  1994/09/15  07:04:54  dalke
 * Added "information" commands for the tracker (like ListAvail, Loc, ...)
 * Added pause/ unpause Command (CmdTrackerPause, CmdTrackerUnpause)
 *
 * Revision 1.1  1994/09/07  07:56:04  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDTRACKER_H
#define CMDTRACKER_H

#include "Command.h"
#include "utilities.h"

// these are the Commands used:
//      TRACKER_START, TRACKER_PAUSE, TRACKER_LIST, TRACKER_LIST_AVAIL,
//      TRACKER_LOC, TRACKER_UNPAUSE,

/////////////////////////// Start a tracker
class CmdTrackerStart : public Command {

private:
  int availnum;
  char *hostname;

protected:
  virtual int do_execute(void);

public:
  CmdTrackerStart(int, char *, int = (-1));
  CmdTrackerStart(int, int = (-1));
  virtual ~CmdTrackerStart(void);
};


/////////////////////////// Pause a tracker, given its number on the list
class CmdTrackerPause : public Command {  //##########

private:
  int trackernum;

protected:
  virtual int do_execute(void);

public:
  CmdTrackerPause(int, int = -1);
};


/////////////////////////// Unpause a tracker, given its number on the list
class CmdTrackerUnpause : public Command {  //##########

private:
  int trackernum;

protected:
  virtual int do_execute(void);

public:
  CmdTrackerUnpause(int, int = -1);
};


/////////////////////////// list all the available trackers
class CmdTrackerListAvail : public Command {

protected:
  virtual int do_execute(void);  // leave it up to the .C file

public:
  CmdTrackerListAvail(int = -1);
};


/////////////////////////// list all running trackers
class CmdTrackerList : public Command {

protected:
  virtual int do_execute(void);

public:
  CmdTrackerList(int = -1);
};
    

/////////////////////////// print the current location of a tracker/ sensor pair
class CmdTrackerLoc : public Command {

private:
  int trackernum;
  int sensornum;

protected:
  virtual int do_execute( void);

public:
  // constructor: tracker #, sensor #, ui id
  CmdTrackerLoc(int, int, int = -1);
};

#endif
