/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTool.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/03/24 18:48:09 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Commands which control the tool 
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdTool.h,v $
 * Revision 1.3  95/03/24  18:48:09  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/11/07  06:56:33  dalke
 * Got rid of "soft" stack -- I now change tools via a Command
 *
 ***************************************************************************/
#ifndef CMDTOOL_H
#define CMDTOOL_H
// Commands which can be sent to the Tools
#include "Command.h"
extern class Tool;

// return the base characteristics of a Tool
// ie., size, length, detail, and tool name
class CmdToolInfo : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  CmdToolInfo(int which_tool, int UIid = -1);
};

// set the tool's base characteristics to a specific number
class CmdToolSetSize : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  float scale, length;
  int detail;
  CmdToolSetSize(int which_tool, 
                 float new_scale = 0.0,  // overall scaling factor >0
                 float new_length = 0.0, // length of tool >0
                 int new_detail = 0,     // detail ranges from 1 to 10 (best)
                 int UIid = -1);         // defaults do nothing
};

// alter the tool's base characteristics by a relative number
class CmdToolAddSize : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  float scale, length;
  int detail;
  CmdToolAddSize(int which_tool, 
                 float new_scale = 0.0,
                 float new_length = 0.0,
                 int new_detail = 0,    
                 int UIid = -1);
};


// change the offset to some new position
class CmdToolSetOffset : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  float delta[3];
  CmdToolSetOffset(int which_tool, float *newpos, int UIid = -1);
  CmdToolSetOffset(int which_tool, float x, float y, float z, int UIid = -1);
};

// change the offset by some relative amount
class CmdToolAddOffset : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  float delta[3];
  CmdToolAddOffset(int which_tool, float *newpos, int UIid = -1);
  CmdToolAddOffset(int which_tool, float x, float y, float z, int UIid = -1);
};

// put another tool on the ToolControl stack
class CmdToolPush : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  Tool *tool;
  CmdToolPush(int which_tool, Tool *newtool, int UIid = -1);
};

// take a tool off the ToolControl stack
class CmdToolPop : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  CmdToolPop(int which_tool, int UIid = -1);
};

// replace the top tool with another
class CmdToolReplace : public Command {
protected:
  virtual int do_execute(void);
public:
  int toolid;
  Tool *tool;
  CmdToolReplace(int which_tool, Tool *newtool, int UIid = -1);
};


#endif
