/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTool.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 95/03/24 18:48:07 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Commands which control the tool 
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdTool.C,v $
 * Revision 1.4  95/03/24  18:48:07  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/11/07  06:57:10  dalke
 * Got rid of "soft" stack -- I now change tools via a Command
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdTool.C,v 1.4 95/03/24 18:48:07 billh Exp $";
#endif

#include "CmdTool.h"
#include "utilities.h"
#include "UIVR.h"

#define MIN_SCALE  0.01
#define MIN_LENGTH 0.05
#define MIN_DETAIL 1
#define MAX_SCALE  20
#define MAX_LENGTH 20
#define MAX_DETAIL 10
#define MAX_OFFSET 20

// check the tool number to see if it is in range
// return FALSE and print an erro if it is not
static int check_tool_range(int toolid)
{
  int n = uiVR->tools.num();
  if (toolid < 0 || toolid >= n) {
     msgErr << "The valid range of tools are: " << 1 << " to " << n << sendmsg;
     return FALSE;
  }
  return TRUE;
}


CmdToolInfo::CmdToolInfo(int which_tool, int UIid)
  : Command(Command::TOOL_INFO, UIid)
{
  toolid = which_tool;
  *cmdText << "tool " << toolid << " info" << ends;
}

// ######################### size

// print info about tool #toolid
int CmdToolInfo::do_execute(void) {
  if (!check_tool_range(toolid))
    return FALSE;
  msgInfo << "Info for tool #" << toolid+1 << "\n";
  msgInfo << "  Scale: " << uiVR->tools[toolid]->scale() << "\n";
  msgInfo << "  Length: " << uiVR->tools[toolid]->length() << "\n";
  msgInfo << "  Detail: " << uiVR->tools[toolid]->detail() << "\n";
  float *offset = uiVR->tools[toolid]->offset();
  msgInfo << "  Offset is: " << offset[0] << "  " << offset[1] << "  " <<
                  offset[2] << ".\n" << sendmsg;
  return TRUE;
}

/// ############ Size and detail
CmdToolSetSize::CmdToolSetSize(int which_tool,
                   float new_scale,     // overall scaling factor >0
                   float new_length,   // length of tool >0
                   int new_detail,    // detail ranges from 1 to 10 (best)
                   int UIid)
 : Command (Command::TOOL_SIZE, UIid)
{
  toolid = which_tool;
  scale = new_scale;
  length = new_length;
  detail = new_detail;
  *cmdText << "tool " << which_tool+1 << " set ";
  if (scale > 0)
    *cmdText << "scale " << scale;
  if (length > 0)
    *cmdText << "length " << length;
  if (detail > 0)
    *cmdText << "detail " << detail;
  *cmdText << ends;
}

int CmdToolSetSize::do_execute(void) {
  if (!check_tool_range(toolid))
    return FALSE;
  ToolControl *tmptool = uiVR->tools[toolid];

  if (scale > 0) {
  tmptool->scale(scale);
  if (tmptool->scale() < MIN_SCALE)
    tmptool->scale(MIN_SCALE);
   else if (tmptool->scale() > MAX_SCALE)
    tmptool->scale(MAX_SCALE);
  }
  if (length > 0) {
  tmptool->length(length);
  if (tmptool->length() < MIN_LENGTH)
    tmptool->length(MIN_LENGTH);
   else if (tmptool->length() > MAX_LENGTH)
    tmptool->length(MAX_LENGTH);
  }
  if (detail > 0) {
  tmptool->detail(detail);
  if (tmptool->detail() < MIN_DETAIL)
    tmptool->detail(MIN_DETAIL);
   else if (tmptool->detail() > MAX_DETAIL)
    tmptool->detail(MAX_DETAIL);
  }
  return TRUE;
}

CmdToolAddSize::CmdToolAddSize(int which_tool,
                   float new_scale,     // overall scaling factor >0
                   float new_length,   // length of tool >0
                   int new_detail,    // detail ranges from 1 to 10 (best)
                   int UIid)
 : Command (Command::TOOL_SIZE, UIid)
{
  toolid = which_tool;
  scale = new_scale;
  length = new_length;
  detail = new_detail;
  *cmdText << "tool " << which_tool+1 << " add ";
  if (scale > 0)
    *cmdText << "scale " << scale;
  if (length > 0)
    *cmdText << "length " << length;
  if (detail > 0)
    *cmdText << "detail " << detail;
  *cmdText << ends;
}

int CmdToolAddSize::do_execute(void) {
  if (!check_tool_range(toolid))
    return FALSE;
  ToolControl *tmptool = uiVR->tools[toolid];
  tmptool->scale(scale + tmptool->scale());
  if (tmptool->scale() < MIN_SCALE)
    tmptool->scale(MIN_SCALE);
   else if (tmptool->scale() > MAX_SCALE)
    tmptool->scale(MAX_SCALE);

  tmptool->length(length + tmptool->length());
  if (tmptool->length() < MIN_LENGTH)
    tmptool->length(MIN_LENGTH);
   else if (tmptool->length() > MAX_LENGTH)
    tmptool->length(MAX_LENGTH);

  tmptool->detail(detail + tmptool->detail());
  if (tmptool->detail() < MIN_DETAIL)
    tmptool->detail(MIN_DETAIL);
   else if (tmptool->detail() > MAX_DETAIL)
    tmptool->detail(MAX_DETAIL);

  return TRUE;
}

// ######################### Offset
CmdToolSetOffset::CmdToolSetOffset(int which_tool, float *newpos, int UIid)
 : Command(Command::TOOL_OFFSET, UIid)
{
  toolid = which_tool;
  delta[0] = newpos[0];
  delta[1] = newpos[1];
  delta[2] = newpos[2];
  *cmdText << "tool " << toolid+1 << " set offset " << delta[0] << " " <<
         delta[1] << " " << delta[2] << "." << ends;
}
CmdToolSetOffset::CmdToolSetOffset(int which_tool, float x, float y, float z,
   int UIid) : Command(Command::TOOL_OFFSET, UIid)
{
  toolid = which_tool;
  delta[0] = x;
  delta[1] = y;
  delta[2] = z;
  *cmdText << "tool " << toolid+1 << " set offset " << delta[0] << " " <<
         delta[1] << " " << delta[2] << "." << ends;
}

int CmdToolSetOffset::do_execute(void)
{
  if (!check_tool_range(toolid))
    return FALSE;
  if (delta[0] >  MAX_OFFSET) delta[0] =  MAX_OFFSET;
  if (delta[0] < -MAX_OFFSET) delta[0] = -MAX_OFFSET;
  if (delta[1] >  MAX_OFFSET) delta[1] =  MAX_OFFSET;
  if (delta[1] < -MAX_OFFSET) delta[1] = -MAX_OFFSET;
  if (delta[2] >  MAX_OFFSET) delta[2] =  MAX_OFFSET;
  if (delta[2] < -MAX_OFFSET) delta[2] = -MAX_OFFSET;
  
  uiVR->tools[toolid]->offset(delta);
  return TRUE;
}

//  #### delta moves
CmdToolAddOffset::CmdToolAddOffset(int which_tool, float *newpos, int UIid)
 : Command(Command::TOOL_OFFSET, UIid)
{
  toolid = which_tool;
  delta[0] = newpos[0];
  delta[1] = newpos[1];
  delta[2] = newpos[2];
  *cmdText << "tool " << toolid+1 << " add offset " << delta[0] << " " <<
         delta[1] << " " << delta[2] << "." << ends;
}
CmdToolAddOffset::CmdToolAddOffset(int which_tool, float x, float y, float z,
   int UIid) : Command(Command::TOOL_OFFSET, UIid)
{
  toolid = which_tool;
  delta[0] = x;
  delta[1] = y;
  delta[2] = z;
  *cmdText << "tool " << toolid+1 << " add offset " << delta[0] << " " <<
         delta[1] << " " << delta[2] << "." << ends;
}

int CmdToolAddOffset::do_execute(void)
{
  if (!check_tool_range(toolid))
    return FALSE;
  add(delta, delta, uiVR->tools[toolid]->offset());
  if (delta[0] >  MAX_OFFSET) delta[0] =  MAX_OFFSET;
  if (delta[0] < -MAX_OFFSET) delta[0] = -MAX_OFFSET;
  if (delta[1] >  MAX_OFFSET) delta[1] =  MAX_OFFSET;
  if (delta[1] < -MAX_OFFSET) delta[1] = -MAX_OFFSET;
  if (delta[2] >  MAX_OFFSET) delta[2] =  MAX_OFFSET;
  if (delta[2] < -MAX_OFFSET) delta[2] = -MAX_OFFSET;
  
  uiVR->tools[toolid]->offset(delta);
  return TRUE;
}


////////////////////////// Change the current tool

// put another tool on the ToolControl stack

CmdToolPush::CmdToolPush(int which_tool, Tool *newtool, int UIid )
   : Command(Command::TOOL_PUSH, UIid)
{
  toolid = which_tool;
  tool = newtool;
}
int  CmdToolPush::do_execute(void)
{
  if (!check_tool_range(toolid)) {
    delete tool;   // since no one else will
    return FALSE;
  }
  uiVR->tools[toolid] -> push_tool(tool);
  return TRUE;
}

// take a tool off the ToolControl stack
CmdToolPop::CmdToolPop(int which_tool, int UIid )
   : Command(Command::TOOL_POP, UIid)
{
  toolid = which_tool;
}
int CmdToolPop::do_execute(void)
{
  if (!check_tool_range(toolid)) {
    return FALSE;
  }
  uiVR->tools[toolid] -> pop_tool();
  return TRUE;
}

// replace the tool on the ToolControl stack

CmdToolReplace::CmdToolReplace(int which_tool, Tool *newtool, int UIid )
   : Command(Command::TOOL_PUSH, UIid)
{
  toolid = which_tool;
  tool = newtool;
}
int  CmdToolReplace::do_execute(void)
{
  if (!check_tool_range(toolid)) {
    delete tool;   // since no one else will
    return FALSE;
  }
  uiVR->tools[toolid] -> replace_tool(tool);
  return TRUE;
}

