/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdRender.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/03/24 18:48:06 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Render a scene (so far, there is only one, the global one) as some
 * sort of rendered output; postscipt, rayshade, POVray, raster3D, etc.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdRender.h,v $
 * Revision 1.2  95/03/24  18:48:06  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.1  1994/11/24  07:26:41  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDRENDER_H
#define CMDRENDER_H

// the following uses only the Cmdtypes RENDER and RENDERLIST
#include "Command.h"
extern class Scene;
extern class DisplayDevice;


///////////////////////// render the global scene
class CmdRender : public Command {

private:
  Scene *sc;     // this is here for the time in the future when we have
                 // multiple scenes
  DisplayDevice *display;  // ditto, for DisplayDevices (there's only one now)
  char *filename;
  char *method;  // what kind of output?  "postscript", "rayshade", etc.

protected:
  virtual int do_execute(void);
  
public:
  // constructor: method, filename, ui id
  CmdRender(char *, char *, int=(-1));
  
  // destructor
  virtual ~CmdRender(void);
};


/////////////////////// list the available rendering types
class CmdRenderList : public Command {

protected:
  virtual int do_execute(void);

public:
  CmdRenderList(int=(-1));
};

#endif
