/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdMenu.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 95/03/24 18:47:54 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     The menu commands are defined here.  These tell the app to turn a
 * menu on or off; to move a menu; or print the cooordinates of a menu
 * to infoMsg.  A "menu" is a UIObject that has a window.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdMenu.h,v $
 * Revision 1.3  95/03/24  18:47:54  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.2  1994/10/03  01:39:42  dalke
 * Took code from .h to .C, leaving only prototypes (to reduce inlining)
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDMENU_H
#define CMDMENU_H

//// An example of how to move the "main" menu to 12, 50
// commandQueue->addcommand(new CmdMenuMove(uiList->item("main"),12,50))

#include "Command.h"
#include "FormsObj.h"

// The following uses the Cmdtypes "MENU_SHOW", "MENU_MOVE", and
// "MENU_LOC" from the Command class


//////////// turn a menu on/off
class CmdMenuShow : public Command {
public:
  int turnOn;		// if T, turn on; if F, turn off
  int toUIid;		// id of menu to change
  FormsObj *menu;	// pointer to menu to change

protected:
  virtual int do_execute(void) ;

public:
  CmdMenuShow(int changeUIid, int turnon, int fromUIid = -1);
};


//////////// move a menu about
class CmdMenuMove : public Command {
public:
  int x,y;		// the new coordinates
  int toUIid;		// id of menu to change
  FormsObj *menu;	// pointer to menu to change

protected:
  virtual int do_execute(void) ;

public:
  CmdMenuMove(int changeUIid, int newx, int newy, int fromUIid = -1);
};


//////////// print a menu's location
class CmdMenuLoc : public Command {
public:
  int toUIid;		// id of menu to change
  FormsObj *menu;	// pointer to menu to change

protected:
  virtual int do_execute(void) ;

public:
  CmdMenuLoc(int changeUIid, int fromUIid = -1);
};

#endif
