/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdMenu.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 95/03/24 18:47:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     The menu commands are defined here.  These tell the app to turn a
 * menu on or off; to move a menu; or print the cooordinates of a menu
 * to infoMsg.  A "menu" is a UIObject that has a window.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CmdMenu.C,v $
 * Revision 1.4  95/03/24  18:47:52  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.3  1994/10/05  06:58:16  billh
 * Converted to use a ResizeArray instead of a DLinkList in the command queue
 * and ui list.
 *
 * Revision 1.2  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.1  1994/10/03  01:42:46  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/CmdMenu.C,v 1.4 95/03/24 18:47:52 billh Exp $";
#endif


//// An example of how to move the "main" menu to 12, 50
// commandQueue->addcommand(new CmdMenuMove(uiList->item("main"),12,50))

#include "CmdMenu.h"
#include "UIObject.h"
#include "UIList.h"
#include "Global.h"

// The following uses the Cmdtypes "MENU_SHOW", "MENU_MOVE", and
// "MENU_LOC" from the Command class


//////////// turn a menu on/off
int CmdMenuShow::do_execute(void) {
  if (menu) {
    if(turnOn)
      menu -> On();
    else
      menu -> Off();
  }
  return (menu != NULL ? TRUE : FALSE);
}

CmdMenuShow::CmdMenuShow(int changeUIid, int turnon, int fromUIid )
  : Command(Command::MENU_SHOW, fromUIid)  {
  turnOn = turnon;
  toUIid = changeUIid;
  if(toUIid >= 0 && toUIid < uiList->num() && 
  	(uiList->item(toUIid)) -> is_menu() ) {
    menu = (FormsObj *) (uiList->item(toUIid));
    *cmdText << "menu " << menu->name << (turnOn ? " on" : " off");
    *cmdText << ends;
  } else
    menu = NULL;
}


//////////// move a menu about
int CmdMenuMove::do_execute(void) {
  if (menu) {
    menu -> move(x,y);           // then move the menu window
  }
  return (menu != NULL ? TRUE : FALSE);
}

CmdMenuMove::CmdMenuMove(int changeUIid, int newx, int newy, int fromUIid)
  : Command(Command::MENU_MOVE, fromUIid)  {
  x = newx;
  y = newy;
  toUIid = changeUIid;
  if(toUIid >= 0 && toUIid < uiList->num() && 
  	(uiList->item(toUIid)) -> is_menu() ) {
    menu = (FormsObj *) (uiList->item(toUIid));
    *cmdText << "menu " << menu->name << " move " << x << " " << y;
    *cmdText << ends;
  } else
    menu = NULL;
}


//////////// print a menu's location
int CmdMenuLoc::do_execute(void) {
  if (menu) {
    int x, y;
    menu -> where(x,y);           // then move the menu window
    msgInfo << "Menu " << menu->name << " is at " << x << ", " << y
            << sendmsg;
  }
  return (menu != NULL ? TRUE : FALSE);
}

CmdMenuLoc::CmdMenuLoc(int changeUIid, int fromUIid)
  : Command(Command::MENU_LOC, fromUIid)  {
  toUIid = changeUIid;
  if(toUIid >= 0 && toUIid < uiList->num() && 
  	(uiList->item(toUIid)) -> is_menu() ) {
    menu = (FormsObj *) (uiList->item(toUIid));
    *cmdText << "menu " << menu->name << " loc";
    *cmdText << ends;
  } else
    menu = NULL;
}
