/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

// code to get memory from and return memory to the 
// CAVE shared memory arena
#include "CaveRoutines.h"
#include "Inform.h"
#include "cave.h"
#include "Global.h"
#include "CaveDisplayDevice.h"
#include "CaveScene.h"

static void *shared_CAVE_memory_arena = NULL;
//static int firsttime = 1; // is this first time the render routine was called?

void *malloc_from_CAVE_memory(size_t size)
{
  MSGDEBUG(4, "Allocated " << int(size) << " bytes of shared memory."
               <<sendmsg);
  if (shared_CAVE_memory_arena == NULL ) {
     // this should be fun.
     msgErr << "Shared CAVE memory not allocated.  Prepare to crash and burn."
             << sendmsg;
     return NULL;
  } else {
    return amalloc(size, shared_CAVE_memory_arena);   // get memory
  }
}

void free_to_CAVE_memory(void *data) {
  afree(data, shared_CAVE_memory_arena);
}

// get megs o' memory from the CAVE, and create the arena
// Warning:  Don't make me do this twice.
void grab_CAVE_memory(int megs)
{
  int size = (megs>1?megs:1) * 1024 * 1024;
  shared_CAVE_memory_arena = CAVEUserSharedMemory(size);

  if (!shared_CAVE_memory_arena)
    msgErr << "Bad juju in the arena.  We're gonna die!" << sendmsg;
   else
     MSGDEBUG(2,  "Created arena." << sendmsg);
}


// set up the graphics, called from CAVEInitApplication
void cave_gl_init_fn(void) {
}

// return the number of cave render processes
int CAVENumRenderProcesses(void)
{
  return CAVEConfig->ActiveWalls;
}


// clear the screen, if the frame just started
void cave_clear_screen(void) {
  display -> prepare3D(TRUE);
  display -> prepare3D(FALSE);
}

// call the child display renderer, and wait until they are done
void cave_renderer(void) {
     scene -> draw(display);
}

