/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CaveDisplayDevice.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.6 $      $Date: 95/03/24 18:47:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * a CAVE specific display device for VMD
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	CaveDisplayDevice.h,v $
 * Revision 1.6  95/03/24  18:47:20  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 ***************************************************************************/
#ifndef CAVEDISPLAYDEVICE_H
#define CAVEDISPLAYDEVICE_H

#include "GLRenderer.h"
#include "Inform.h"


class CaveDisplayDevice : public GLRenderer {

private:
  // have we initialized the graphics yet?
  int doneGLInit;

  // set up the graphics on the seperate CAVE displays
  void cave_gl_init_fn(void);
  
public:
  // constructor and destructor
  CaveDisplayDevice(void);
  virtual ~CaveDisplayDevice(void);
  
  // cannot change to stereo mode
  virtual void set_stereo_mode(int = 0);
  
  // routines to prepare, draw, and finish, some done by the CAVE
  virtual void prepare2D(int);
  virtual void prepare3D(int);
  virtual void clear(void);
  
  // special render routine to check for graphics initialization
  virtual void render(void *);

};

#endif
