/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Buttons.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 95/03/24 18:47:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Base class for button type inputs which are associated with a tracker/
 * sensor pair.  Also includes two derived classes, KbdButtons (for keyboard
 * entry with the F keys) and CaveButtons (for input from the Cave).
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	Buttons.C,v $
 * Revision 1.6  95/03/24  18:47:16  billh
 * Added copyright notice to top of file; made sure all virtual routines
 * are defined in the .C file, not in the .h file.
 * 
 * Revision 1.5  1994/11/08  09:12:15  dalke
 * set up CaveButtons correctly
 *
 * Revision 1.4  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.3  1994/09/25  22:37:56  billh
 * Changed cave include path, and put in check for VMDCAVE define.
 *
 * Revision 1.2  1994/09/17  10:53:18  dalke
 * added RCS header
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /private/auto143000131/vmdsrc/vmd/billh/src/RCS/Buttons.C,v 1.6 95/03/24 18:47:16 billh Exp $";
#endif

#include <gl/gl.h>
#include <gl/device.h>
#include <string.h>
#include "Buttons.h"

#ifdef VMDCAVE
#include "cave.h"
#endif


/////////////////////////  constructor: number of buttons this object contains
Buttons::Buttons(int n) {
 // make sure the number of buttons is not illegal
 if(n <= 0)
   n = 1;

 // create storage for state and change flags
 numButtons = n;
 state = new int[numButtons];
 changes = new int[numButtons];
 for(int i=0; i < numButtons; i++)
   state[i] = changes[i] = FALSE;
 
 // indicate nothing has changed yet
 has_changed = FALSE;
}


/////////////////////////  destructor
Buttons::~Buttons(void) {
  delete [] state;
  delete [] changes;
}


/////////////////////////  KbdButtons derived class  ////////////////////////

/////////////////////////  constructor: which bank to use
KbdButtons::KbdButtons(int bank) : Buttons(3) {
  if (bank<0)
    bank=0;
  else if (bank>3)
    bank=3;
  my_bank = bank;
  tmp_state = new int[3];
}


/////////////////////////  destructor
KbdButtons::~KbdButtons(void) {
  delete [] tmp_state;
}


// Looks at the keyboard to update button info.
// There are three allowed "banks" of input, bank
// 0 consists of "F1 F2 F3", bank 1 of "F5 F6 F7"
// and bank 2, "F9 F10 F11".  
//   This reads in from the appropriate bank,
// figures out which buttons changed, and updates
// everything appropriately
void KbdButtons::check_event(void)
{
  memcpy(tmp_state, state, num()*sizeof(float)); // save prev state
  
                                 // get the current button state
  switch(my_bank) {
    case 0:
       state[0] = getbutton(F1KEY) ? TRUE : FALSE;
       state[1] = getbutton(F2KEY) ? TRUE : FALSE;
       state[2] = getbutton(F3KEY) ? TRUE : FALSE;
       break;
    case 1:
       state[0] = getbutton(F5KEY) ? TRUE : FALSE;
       state[1] = getbutton(F6KEY) ? TRUE : FALSE;
       state[2] = getbutton(F7KEY) ? TRUE : FALSE;
       break;
    case 2:
       state[0] = getbutton(F9KEY)  ? TRUE : FALSE;
       state[1] = getbutton(F10KEY) ? TRUE : FALSE;
       state[2] = getbutton(F11KEY) ? TRUE : FALSE;
       break;
    default: 
       state[0] = state[1] = state[2] = FALSE;
       changes[0] = changes[1] = changes[2] = FALSE;
       has_changed = FALSE;
       return ;
  }
  
  // now see who has changed
  has_changed = FALSE;
  for (int i=2; i>=0; i--)
     // something has changed if the current state isn't like the last one
    has_changed = has_changed || 
                  ((changes[i] = state[i] - tmp_state[i] )!=0);
}


/////////////////////////  CaveButtons derived class  ////////////////////////

#ifdef VMDCAVE

/////////////////////////  constructor
CaveButtons::CaveButtons(void) : Buttons(3) {
  tmp_state = new int[3];
}


/////////////////////////  destructor
CaveButtons::~CaveButtons(void) {
  delete [] tmp_state;
}


// Looks at the CAVE hardware to get the button presses
void CaveButtons::check_event(void)
{
  memcpy(tmp_state, state, num()*sizeof(float)); // save prev state
  state[0] = CAVEBUTTON1;
  state[1] = CAVEBUTTON2;
  state[2] = CAVEBUTTON3;
   // now see who has changed
  has_changed = FALSE;
  for (int i=2; i>=0; i--)
     // something has changed if the current state isn't like the last one
    has_changed = has_changed || 
                  ((changes[i] = state[i] - tmp_state[i] )!=0);
}

#endif  
