/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIObject.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1994/10/19 20:23:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * User Interface Object base class.  All user interface modules are derived
 * from this; it provides methods for registering with the command processor
 * and 'signing up' for which commands it is interested in, as well as
 * generating commands and events.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: UIObject.C,v $
 * Revision 1.3  1994/10/19  20:23:08  billh
 * Made 'On' and 'Off' virtual routines in every UIObject, and added virtual
 * routine 'is_on' to test for whether the ui is on or off (used mainly by
 * Mouse to provide options to toggle forms on and off)
 *
 * Revision 1.2  1994/09/12  20:52:56  billh
 * Made some debugging messages L3 instead of L2 (to reduce L2 verbosity).
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/UIObject.C,v 1.3 1994/10/19 20:23:08 billh Exp $";
#endif

#include "UIObject.h"
#include "UIList.h"
#include "CommandQueue.h"
#include "Command.h"
#include "Inform.h"
#include "utilities.h"


// class constructor: list to register with,, match method
UIObject::UIObject(char *nm, UIList *uil, CommandQueue *cq, match M) {
  int i;
  
  name = stringdup(nm);
  matchMethod = M;
  uiL = uil;
  uiOn = TRUE;
  cmdQueue = cq;

  MSGDEBUG(1,"Creating UIObject '" << name << "' ..." << sendmsg);

  // register this object
  if(uiL) {
    if((myID = uiL->register_UI(this)) < 0) {
      msgErr << "UIObject '" << name << "': cannot register with UIList!"
             << sendmsg;
      matchMethod = NONE;
    }
    maxCmds = Command::TOTAL;
  } else {
    myID = (-1);
    maxCmds = 1;
  }
  
  // init the command flag array  
  doCmd = new char[maxCmds];
  for(i=0; i < maxCmds; doCmd[i++] = FALSE);
}


// destructor; just deregister the UI
UIObject::~UIObject(void) {
// currently, there is no unregister option.
//  if(uiList && myID >= 0)
//    uiList->unregister_UI(myID);
  
  MSGDEBUG(1,"Deleting UIObject '" << name << "' ..." << sendmsg);

  delete [] doCmd;
  delete [] name;
}


// send a command to the command queue
void UIObject::addcommand(Command *cmd) {
  if(cmdQueue && cmd) {

    MSGDEBUG(3,"UIObject '" << name << "': adding command:\n");
    MSGDEBUG(3,"--> " << *cmd << sendmsg);

    cmdQueue->append(cmd);
  }
}

