/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: UIExternal.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/22 08:55:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * defines the interface to external UIs
 * for now we only allow input, and don't give output
 * and that input is straight text
 * This works via PVM, since that is easy to do
 * the information about max string size and the pvm message id 
 *    should be moved so others can use it.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: UIExternal.h,v $
 * Revision 1.1  1995/02/22  08:55:55  dalke
 * Initial revision
 *
 ***************************************************************************/


#ifndef UIEXTERNAL_H
#define UIEXTERNAL_H
#include "UIObject.h"
class UIExternal : public UIObject {
private:
  // is >0 if all okay, ==0 if PVM wasn't (or could not) started
  int myid;
  static int uniqid;   // uniq id for the above

  int ison;

  static int pvmcount; // how many instances of pvm are there?
  void leave_pvm(void); // stop listening and, maybe, detach from PVM

public:
  UIExternal(UIList *, CommandQueue *);  // constructor
  virtual ~UIExternal( void);
  
    // initialize this class
  virtual void init(void) { ; }

   // reset everything
  virtual void reset(void ) { ; }

  // update the displays
  virtual void update(void) { ; }

  // don't need to do anything .... so I don't
  virtual int act_on_command(int, Command *, int) {return FALSE;}

  // check for a new string and queue it if found.  
  // Returns TRUE if an event was generated.  
  virtual int check_event(void);

  int start_listening(void);
  int stop_listening(void);
};

#define EXTERNALD_MAXSTRLEN 200
#define EXTERNAL_TEXTEVENT 8000


#endif // UIEXTERNAL_H
