/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ToolControl.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1994/11/07 06:59:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   A ToolControl does several things, it reads in the information
 * from the assigned tracker/sensor.   It sets up about 1/2 of the
 * data structure used by the Tool (the tool does the rest).  It maintains
 * a stack of tools in use.  Thus, pressing a button could put the
 * current tool representation on "hold" while something else comes into
 * effect. 
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ToolControl.h,v $
 * Revision 1.5  1994/11/07  06:59:14  dalke
 * Got rid of "soft" tool stack
 *
 * Revision 1.4  1994/10/04  09:06:24  dalke
 * now set needRegenerate if detail changes in Tool
 *
 * Revision 1.3  1994/10/03  08:35:41  dalke
 * changed resolution to detail, replaced static toolcount by
 *   constructor parameter
 *
 * Revision 1.2  1994/10/02  10:56:52  dalke
 * Added a unique id for each ToolControl
 *
 * Revision 1.1  1994/09/26  07:15:16  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef TOOLCONTROL_H
#define TOOLCONTROL_H


#include "Stack.h"
#include "Tool.h"


class ToolControl {  // does all the work to translate the pointer/sensor
                // information to the virtual world, then calls the Tool
private:
  Stack<Tool *> my_tool;   // does "stuff" and makes the representation

  float delta[3];  // this offset applied to tracker coords to get base
  ToolInfo my_info;
    
  void reset(void);  // reset everything to the original
  int pop_count;     // for the delayed_pop_tool; how many pops to do?
public:
  // constructor needs default tool
  ToolControl(int which_id, Tool *default_tool);
  virtual ~ToolControl(void) {   // destructor
    reset();
  };
    
  Tracker *tracker(void) {        // return the tracker * I'm using
    return my_info.tracker;
  }
  int sensor(void) {              // return the sensor number I'm using
    return my_info.sensor;
  }
  Buttons *buttons(void) {              // return the button *  I'm using
    return my_info.buttons;
  }
  
  void tracker(Tracker *tracker, int sensor) {  // change tracker/ sensor
    my_info.tracker = tracker;
    my_info.sensor = sensor;
    my_info.buttons = tracker -> get_buttons(sensor);
    if (!my_info.buttons) {
      msgErr << "Cannot get buttons for sensor " << sensor << sendmsg;
    }
    MSGDEBUG(1, "Changed the tracker on the tool" << sendmsg);
  }  
  
  float *offset(void) {  // return the current offset
    return delta;
  }
  void moveby(float *offset) {  // change the offset by some offset
    delta[0]+=offset[0];
    delta[1]+=offset[1];
    delta[2]+=offset[2];
  }
  void offset(float *offset) { // change the delta to an absolute vector
    delta[0]=offset[0];
    delta[1]=offset[1];
    delta[2]=offset[2];
  }
  
  // length/ width/ size changes####################
  void length(float newlen) {
    my_info.internal_length = newlen;
    my_info.length = my_info.internal_length * my_info.scale;
  }
  float length(void) {
    return my_info.internal_length;
  }
  void radius(float newradius) {
    my_info.internal_radius = newradius;
    my_info.radius = my_info.internal_radius * my_info.scale;
  }
  float radius(void) {
    return my_info.internal_radius;
  }
  void scale(float newscale) {
    my_info.length = my_info.internal_length * newscale;
    my_info.radius = my_info.internal_radius * newscale ;
    my_info.scale = newscale;
  }
  float scale(void) {
    return my_info.scale;
  }
  
  // detail changes
  void detail(int newres) {
    if (newres < 1) newres = 1;
    if (newres > 10) newres = 10;
    my_info.detail = newres;
    if (my_tool.top())  // this is something the tool must do
      my_tool.top()->needRegenerate = TRUE;
  }
  int detail(void) {
    return my_info.detail;
  }
  // functions to manipulate the current Tool ##################
  void replace_tool(Tool *new_tool) {       // change the tool
    if (my_tool.stack_size()>1)         // don't ever delete the default Tool
      pop_tool();
    push_tool(new_tool);
  }
  void push_tool(Tool *new_tool) {  // use another tool, but save the old
    my_tool.top() -> off(); 
    my_tool.push(new_tool);
  }
  void pop_tool(void) {
    if (my_tool.stack_size()>1) { // leave the default Tool!!!!
      delete my_tool.top(); // out with the current tool
      my_tool.pop();
      my_tool.top() -> on();   // and in with the older one
    }
  }
  Tool *top_tool(void) {
    return my_tool.top();
  }
  
  // check_event figures the appropriate info (locations, etc), and
  //   calls the Tool with that information
  void check_event(void);
};

#endif
