/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Timestep.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1994/11/09 02:50:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The Timestep class, which stores coordinates, energies, etc. for a
 * single timestep.
 *
 * Note: As more data is stored for each step, it should go in here.  For
 * example, H-Bonds could be calculated each step.
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Timestep.h,v $
 * Revision 1.4  1994/11/09  02:50:28  billh
 * Added finished support for displaying patches for a remote molecule.
 *
 * Revision 1.3  94/10/01  11:02:04  billh
 * Added a couple more energy terms to store.
 * 
 * Revision 1.2  94/09/24  20:10:49  billh
 * Added 'maxrad' member, which is the radius of a sphere which will
 * entirely contain the positions for this timestep, if it were centered
 * at the center of volume.
 * 
 * Revision 1.1  94/09/17  09:11:36  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef TIMESTEP_H
#define TIMESTEP_H

#include "Atom.h"

//
// useful defines
//

// energy terms and temperature stored for each timestep
#define TSE_BOND	0
#define TSE_ANGLE	1
#define TSE_DIHE	2
#define TSE_IMPR	3
#define TSE_VDW		4
#define TSE_COUL	5
#define TSE_HBOND	6
#define TSE_KE		7
#define TSE_PE		8
#define TSE_TEMP	9
#define TSE_TOTAL	10
#define TSENERGIES	TSE_TOTAL + 1

// patch data values stored
#define TSP_X		0
#define TSP_Y		1
#define TSP_Z		2
#define TSP_XLEN	3
#define TSP_YLEN	4
#define TSP_ZLEN	5
#define TSP_LOAD	6
#define TSP_ATOMS	7
#define TSP_NODE	8
#define TSPATCHDATA	9


class Timestep {

private:
  // do we need to deallocate the space for the 'data' array?
  int needDataDelete;

// while this is a class, almost all the members are public
public:
  // number of atoms this timestep is for
  int num;
  
  // coordinates of all the atoms, as (x,y,z), (x,y,z), ...
  float *pos;
  
  // extra data for each atom: temperature and B-factors (this may just
  // be a pointer from some other object)
  float *data;
  
  // energy for this step; by default, all 0
  float energy[TSENERGIES];
  
  // number of patches for this timestep; if zero, none or not relevant
  int numPatches;
  
  // data for each patch: position of corner, size, and other values
  float *patchData;

  // minimum and maximum values for position and data and patch data
  float minpos[ATOMCOORDS];
  float maxpos[ATOMCOORDS];
  float mindata[ATOMEXTRA];
  float maxdata[ATOMEXTRA];
  float minpatch[TSPATCHDATA];
  float maxpatch[TSPATCHDATA];
  float maxrad;			// calculated relative to COV

  // center of volume position
  float COV[ATOMCOORDS];

  // scale factor to get the coordinate set to fix in (-1 ... 1) box
  float scale_factor;

  // time required to compute this timestep .... if unknown, should be 0
  float dt;

  // has this timestep been initialized?
  int Initialized;

public:
  // constructor: # atoms, time used to compute this timestep,
  // and 'data' items; if latter is null, space is allocated.
  Timestep(int n, float DT, float *newdata = NULL);
  
  // destructor
  ~Timestep(void);
  
  // create storage to store n patches; returns pointer to beginning
  // of data block
  float *create_patch_storage(int);

  // calculate the max/min values for all the quantities, and anything else
  // required based on atom coordinates, etc.  Used for scaling
  // and translating purposes.
  void init(void);

};

#endif
