/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Stack.c,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/01/29 19:58:42 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Stack template
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Stack.c,v $
 * Revision 1.1  1995/01/29  19:58:42  billh
 * Initial revision
 *
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/Stack.c,v 1.1 1995/01/29 19:58:42 billh Exp $";
#endif

#include "Stack.h"
#include "Inform.h"

////////////////////  constructor
template<class T>
Stack<T>::Stack(int s) {
  MSGDEBUG(1,"Created new Stack of size " << s << " ..." << sendmsg);

  items = 0;
  data = curr = new T[sz = (s > 0 ? s : 1)];
}


////////////////////  destructor
template<class T>
Stack<T>::~Stack(void) {
  MSGDEBUG(3, "Deleting Stack with " << num() << " items ..." << sendmsg);
  
  if(data)
    delete [] data;
}

  
///////////////////
///////////////////  public routines
///////////////////

// push a new item onto the stack.
template<class T>
Stack<T>& Stack<T>::push(const T& a) {
  if(items < sz) {
    *curr++ = a;
    items++;
  } else {
    msgErr << "Stack push: stack size " << max_stack_size() << " exceeded.";
    msgErr << sendmsg;
  }
  return *this;
}

  
// push the stack, making a copy of the top element
template<class T>
Stack<T>& Stack<T>::push(void) {
  if(items > 0) {
    push(top());
  } else if(sz > 0) {
    curr++;
    items++;
  }
  return *this;
}


// pop the stack
template<class T>
T& Stack<T>::pop(void) {
  if(items > 0) {
    items--;
    return (*--curr);
  } else {
    msgErr << "Stack pop: stack empty." << sendmsg;
    return *data;
  }
}


// return reference to top item, but do not pop the stack
template<class T>
T& Stack<T>::top(void) {
  if(items > 0) {
    return *(curr - 1);
  } else {
    msgErr << "Stack access: stack empty." << sendmsg;
    return *data;
  }
}
